/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.excel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelUtils {
    private ExcelUtils() {
    }

    public List<String> getSheetHeaders(Sheet sheet) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator rows = sheet.rowIterator();
        Row row = (Row)rows.next();
        Iterator cells = row.cellIterator();
        while (cells.hasNext()) {
            Cell cell = (Cell)cells.next();
            result.add(cell.getStringCellValue());
        }
        return result;
    }

    public List<String> getSheetColumn(Sheet sheet, int index) {
        ArrayList<String> column = new ArrayList<String>();
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            column.add(this.getCellValue(row.getCell(index)));
        }
        return column;
    }

    public Cell getCellInRowByColumnName(Sheet sheet, Row row, String columnName) {
        int column = this.getSheetHeaders(sheet).indexOf(columnName);
        return row.getCell(column);
    }

    public Cell getCell(Sheet sheet, int row, int column) {
        return sheet.getRow(row).getCell(column);
    }

    public String getCellValue(Cell cell) {
        switch (cell.getCellTypeEnum()) {
            case STRING: {
                return cell.getRichStringCellValue().getString();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue().toString();
                }
                return Long.toString((long)cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case FORMULA: {
                try {
                    return cell.getStringCellValue();
                }
                catch (Exception e) {
                    return String.valueOf(cell.getNumericCellValue());
                }
            }
        }
        return "";
    }

    public Row getRowByTestCaseName(Sheet sheet, String name) {
        if (sheet != null) {
            for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
                Row row = sheet.getRow(i);
                if (!this.getCellValue(row.getCell(0)).toLowerCase().trim().equals(name.toLowerCase().trim())) continue;
                return row;
            }
        }
        return null;
    }

    public boolean isCellHidden(Cell cell) {
        if (cell != null) {
            Row row = cell.getRow();
            return row.getZeroHeight();
        }
        return true;
    }

    public boolean isRowHidden(Row row) {
        if (row != null) {
            return row.getZeroHeight();
        }
        return true;
    }

    public int getRowNumbers(Sheet sheet) {
        return sheet.getPhysicalNumberOfRows();
    }
}

