/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.file;

import io.github.marcperez06.java_utilities.strings.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileUtils {
    private static final String DIRECTORY = "directory";
    private static final String FILE = "file";

    private FileUtils() {
    }

    public static boolean existFile(String path) {
        boolean existFile = false;
        try {
            File file = new File(path);
            existFile = file.exists();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return existFile;
    }

    public static File createFileIfNotExist(String path) {
        return FileUtils.createFileIfNotExist(path, FILE);
    }

    private static File createFileIfNotExist(String path, String typeOfFile) {
        File file = null;
        try {
            file = new File(path);
            FileUtils.createParentFileIfNotExist(file);
            FileUtils.createFileOrDirectory(file, typeOfFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            file = null;
        }
        return file;
    }

    private static void createParentFileIfNotExist(File child) {
        File parent = child.getParentFile();
        if (parent != null && !parent.exists()) {
            FileUtils.createFileIfNotExist(parent.getAbsolutePath(), DIRECTORY);
        }
    }

    private static void createFileOrDirectory(File file, String typeOfFile) {
        try {
            if (!file.exists()) {
                if (typeOfFile.equals(DIRECTORY)) {
                    file.mkdir();
                } else if (typeOfFile.equals(FILE)) {
                    file.createNewFile();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static BufferedReader createReader(String path) throws IOException {
        return new BufferedReader(new FileReader(path));
    }

    private static BufferedWriter createWriter(String path) throws IOException {
        BufferedWriter bufferedWriter = null;
        File file = new File(path);
        if (file != null) {
            file.setWritable(true);
            FileWriter fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
        }
        return bufferedWriter;
    }

    private static BufferedWriter createWriterWithEncoding(String path, String encoding) throws IOException {
        BufferedWriter bufferedWriter = null;
        FileOutputStream fileOutputStream = new FileOutputStream(path);
        if (fileOutputStream != null) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, encoding);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
        }
        return bufferedWriter;
    }

    public static String getStringOfFile(String path) {
        String lineText = "";
        String text = "";
        try (BufferedReader reader = FileUtils.createReader(path);){
            while ((lineText = reader.readLine()) != null) {
                text = text + lineText + "\n";
            }
            text = StringUtils.cutStringWithOtherString(text, "\n", 0);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return text;
    }

    public static List<String> getStringListOfFile(String path) {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = FileUtils.createReader(path);){
            String lineText;
            while ((lineText = reader.readLine()) != null) {
                lines.add(lineText);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            lines.clear();
        }
        return lines;
    }

    public static List<String> getStringListOfFileIgnoringLinesThatContainsWords(String path, String ... wordsToIgnore) {
        String lineText = "";
        ArrayList<String> lines = new ArrayList<String>();
        boolean ignore = false;
        try (BufferedReader reader = FileUtils.createReader(path);){
            while ((lineText = reader.readLine()) != null) {
                ignore = false;
                for (int i = 0; i < wordsToIgnore.length && !ignore; ++i) {
                    String word = wordsToIgnore[i];
                    if (!lineText.contains(word)) continue;
                    ignore = true;
                }
                if (ignore || lineText.isEmpty()) continue;
                lines.add(lineText);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            lines.clear();
        }
        return lines;
    }

    public static Map<String, List<String>> getMapOfCsv(String path) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String lineText = "";
        try (BufferedReader reader = FileUtils.createReader(path);){
            lineText = reader.readLine();
            String[] keys = lineText.split(",");
            for (int i = 0; i < keys.length; ++i) {
                map.put(keys[i], new ArrayList());
            }
            while ((lineText = reader.readLine()) != null) {
                String[] values = lineText.split(",");
                for (int j = 0; j < keys.length; ++j) {
                    if (j < values.length) {
                        ((List)map.get(keys[j])).add(values[j]);
                        continue;
                    }
                    ((List)map.get(keys[j])).add(null);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            map.clear();
        }
        return map;
    }

    public static String getStringOfAllFilesInOneDirectory(String path) {
        File inDir = new File(path);
        File[] flist = inDir.listFiles();
        String floc = "";
        String text = "";
        String finaltext = "";
        for (int f = 0; f < flist.length; ++f) {
            floc = flist[f].getAbsolutePath();
            text = FileUtils.getStringOfFile(floc);
            finaltext = finaltext + text;
        }
        return finaltext;
    }

    public static List<String> getStringListOfAllFilesInOneDirectory(String path) {
        File inDir = new File(path);
        File[] flist = inDir.listFiles();
        String floc = "";
        String text = "";
        ArrayList<String> listOfFileText = new ArrayList<String>();
        if (flist != null) {
            for (int f = 0; f < flist.length; ++f) {
                floc = flist[f].getAbsolutePath();
                text = FileUtils.getStringOfFile(floc);
                if (text.isEmpty()) continue;
                listOfFileText.add(text);
            }
        }
        return listOfFileText;
    }

    public static List<String> getListOfAbsolutePathsInDirectory(String directory) {
        File inDir = new File(directory);
        File[] flist = inDir.listFiles();
        String floc = "";
        ArrayList<String> listOfPaths = new ArrayList<String>();
        if (flist != null) {
            for (int f = 0; f < flist.length; ++f) {
                floc = flist[f].getAbsolutePath();
                listOfPaths.add(floc);
            }
        }
        return listOfPaths;
    }

    public static boolean addLineInFile(String line, String path) {
        boolean addLine = false;
        if (!FileUtils.existFile(path)) {
            FileUtils.writeTxt(line, path);
        } else {
            try (BufferedWriter bufferedWritter = FileUtils.createWriter(path);){
                bufferedWritter.append(line);
                addLine = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                addLine = false;
            }
        }
        return addLine;
    }

    public static boolean addLineInFileWithEncoding(String line, String path, String encoding) {
        boolean addLine = false;
        if (!FileUtils.existFile(path)) {
            FileUtils.writeTxtWithEncoding(line, path, encoding);
        } else {
            try (BufferedWriter bufferedWriter = FileUtils.createWriterWithEncoding(path, encoding);){
                bufferedWriter.append(line);
                addLine = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                addLine = false;
            }
        }
        return addLine;
    }

    public static boolean writeTxt(String txt, String path) {
        boolean write = false;
        File file = FileUtils.createFileIfNotExist(path);
        if (file != null) {
            try (BufferedWriter bufferedWritter = FileUtils.createWriter(path);){
                bufferedWritter.write(txt);
                write = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                write = false;
            }
        }
        return write;
    }

    public static boolean writeTxtWithEncoding(String txt, String path, String encoding) {
        boolean write = false;
        File file = FileUtils.createFileIfNotExist(path);
        if (file != null) {
            try (BufferedWriter bufferedWritter = FileUtils.createWriterWithEncoding(path, encoding);){
                bufferedWritter.write(txt);
                write = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                write = false;
            }
        }
        return write;
    }

    public static boolean deleteFile(String path) {
        boolean fileDeleted = false;
        if (path != null && path.isEmpty()) {
            File file = new File(path);
            fileDeleted = FileUtils.deleteFile(file);
        }
        return fileDeleted;
    }

    public static boolean deleteFile(File file) {
        boolean fileDeleted = false;
        if (file != null) {
            fileDeleted = file.delete();
            if (fileDeleted) {
                System.out.println("The file was deleted");
            } else {
                System.out.println("The file can not be deleted");
            }
        }
        return fileDeleted;
    }

    public static boolean deleteDirectory(String path) {
        boolean directoryDeleted = false;
        if (path != null && path.isEmpty()) {
            File directory = new File(path);
            directoryDeleted = FileUtils.deleteDirectory(directory);
        }
        return directoryDeleted;
    }

    public static boolean deleteDirectory(File directory) {
        boolean directoryDeleted = false;
        if (directory != null && directory.exists()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.isDirectory()) {
                        FileUtils.deleteDirectory(file);
                        continue;
                    }
                    file.delete();
                }
            }
            directoryDeleted = directory.delete();
        }
        return directoryDeleted;
    }
}

