/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.gherkin.objects;

import io.github.marcperez06.java_utilities.gherkin.objects.GherkinCriteria;
import io.github.marcperez06.java_utilities.gherkin.objects.GherkinVariable;
import io.github.marcperez06.java_utilities.strings.StringUtils;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GherkinObject {
    private static final String BACKGROUND = "Background";
    private static final String AND = "And";
    private static final String EXAMPLES = "Examples";
    private String scenarioName;
    private GherkinCriteria feature;
    private GherkinCriteria scenario;
    private List<String> content;
    private List<String> backgroundContent;
    private Map<String, List<GherkinCriteria>> background;
    private List<GherkinCriteria> givens;
    private List<GherkinCriteria> whens;
    private List<GherkinCriteria> thens;
    private List<String> examplesContent;
    private Map<String, List<GherkinVariable>> examplesValues;

    public GherkinObject(GherkinCriteria feature) {
        this.feature = feature;
        this.backgroundContent = new ArrayList<String>();
        this.background = new HashMap<String, List<GherkinCriteria>>();
        this.examplesValues = new HashMap<String, List<GherkinVariable>>();
    }

    public GherkinObject(GherkinCriteria feature, List<String> scenarioContent) {
        this(feature);
        this.fillInfo(scenarioContent);
    }

    public GherkinCriteria getFeature() {
        return this.feature;
    }

    public List<String> getBackgroundContet() {
        return this.backgroundContent;
    }

    public Map<String, List<GherkinCriteria>> getBackground() {
        return this.background;
    }

    public GherkinCriteria getScenario() {
        return this.scenario;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public List<String> getContent() {
        return this.content;
    }

    public List<GherkinCriteria> getGivens() {
        return this.givens;
    }

    public List<GherkinCriteria> getWhens() {
        return this.whens;
    }

    public List<GherkinCriteria> getThens() {
        return this.thens;
    }

    public Map<String, List<GherkinVariable>> getExamplesValues() {
        return this.examplesValues;
    }

    public void fillInfo(List<String> scenarioContent) {
        this.content = scenarioContent;
        this.fillBackgroundInfo(scenarioContent);
        this.fillScenario(scenarioContent);
        this.givens = this.getCriteriaLines(scenarioContent, "Given");
        this.whens = this.getCriteriaLines(scenarioContent, "When");
        this.thens = this.getCriteriaLines(scenarioContent, "Then");
        this.fillExamplesMap(scenarioContent);
    }

    private void fillBackgroundInfo(List<String> lines) {
        this.fillBackgroundContent(lines);
        if (!this.backgroundContent.isEmpty()) {
            this.fillBackground();
        }
    }

    private void fillBackgroundContent(List<String> lines) {
        boolean isScenario = false;
        boolean takeBackgroundContent = false;
        for (int i = 0; i < lines.size() && !isScenario; ++i) {
            String line = this.clearLineForAnnotation(lines.get(0));
            if (line.isEmpty()) continue;
            boolean isBackground = line.startsWith(BACKGROUND);
            if (takeBackgroundContent) {
                this.backgroundContent.add(line);
            }
            if (isBackground) {
                takeBackgroundContent = true;
                continue;
            }
            isScenario = line.startsWith("Scenario");
            takeBackgroundContent = false;
        }
    }

    private void fillBackground() {
        List<GherkinCriteria> givens = this.getCriteriaLines(this.backgroundContent, "Given");
        List<GherkinCriteria> whens = this.getCriteriaLines(this.backgroundContent, "When");
        List<GherkinCriteria> thens = this.getCriteriaLines(this.backgroundContent, "Then");
        if (!givens.isEmpty()) {
            this.background.put("Given", givens);
        }
        if (!whens.isEmpty()) {
            this.background.put("When", whens);
        }
        if (!whens.isEmpty()) {
            this.background.put("Then", thens);
        }
    }

    private void fillScenario(List<String> lines) {
        boolean found = false;
        this.scenarioName = "";
        for (int i = 0; i < lines.size() && !found; ++i) {
            boolean isScenario;
            String line = this.clearLine(lines.get(i));
            if (line.isEmpty() || !(isScenario = line.startsWith("Scenario"))) continue;
            String[] scenarioLine = line.split(" ");
            scenarioLine[0] = "";
            String scenario = StringUtils.concatArrayOfString(scenarioLine, " ").trim();
            this.scenarioName = this.getScenarioName(scenario);
            if (i > 0) {
                String previousLine = this.clearLine(lines.get(i - 1));
                this.scenario = this.createGherkinCriteria("Scenario", previousLine, scenario);
            }
            found = true;
        }
    }

    private String getScenarioName(String scenario) {
        String scenarioName = "";
        String[] scenarioLine = scenario.split(" ");
        StringBuilder stringBuilder = new StringBuilder();
        String[] specialCharacters = new String[]{"\\\\", "\\/", "\\[", "\\]", "\\{", "\\}", "\\(", "\\)", "\\&", "\\:", "@", "\"", "'"};
        for (String token : scenarioLine) {
            if (token.isEmpty()) continue;
            token = token.trim();
            for (String specialChar : specialCharacters) {
                token = token.replaceAll(specialChar, "");
            }
            token = StringUtils.capitalizeWord(token);
            stringBuilder.append(token);
        }
        stringBuilder.append("Steps");
        scenarioName = stringBuilder.toString();
        return scenarioName;
    }

    private List<GherkinCriteria> getCriteriaLines(List<String> lines, String criteriaType) {
        ArrayList<GherkinCriteria> criteriaLines = new ArrayList<GherkinCriteria>();
        ArrayList<String> previousLines = new ArrayList<String>();
        for (String line : lines) {
            String clearedLine = this.clearLine(line);
            String annotationLine = this.clearLineForAnnotation(line);
            ArrayList<String> copyOfPreviosLines = new ArrayList<String>();
            if (!clearedLine.isEmpty()) {
                copyOfPreviosLines.addAll(previousLines);
                boolean isCriteriaLine = false;
                isCriteriaLine = clearedLine.startsWith(AND) ? this.lineStartsWithCriteriaType(copyOfPreviosLines, criteriaType) : clearedLine.startsWith(criteriaType);
                if (isCriteriaLine) {
                    String previousLine = (String)previousLines.get(previousLines.size() - 1);
                    if (clearedLine.startsWith(AND)) {
                        clearedLine = clearedLine.replaceFirst(AND, criteriaType);
                        annotationLine = annotationLine.replaceFirst(AND, criteriaType);
                    }
                    GherkinCriteria criteria = this.createGherkinCriteria(criteriaType, previousLine, line, annotationLine);
                    criteriaLines.add(criteria);
                }
            }
            previousLines.add(clearedLine);
        }
        return criteriaLines;
    }

    private boolean lineStartsWithCriteriaType(List<String> lines, String criteriaType) {
        boolean lineStartsWithCriteriaType = false;
        if (lines != null && !lines.isEmpty()) {
            int lastLineIndex = lines.size() - 1;
            String previousLine = lines.get(lastLineIndex);
            if (previousLine.startsWith(AND)) {
                lines.remove(lastLineIndex);
                lineStartsWithCriteriaType = this.lineStartsWithCriteriaType(lines, criteriaType);
            } else {
                lineStartsWithCriteriaType = previousLine.startsWith(criteriaType);
            }
        }
        return lineStartsWithCriteriaType;
    }

    private GherkinCriteria createGherkinCriteria(String criteriaType, String previousLine, String line) {
        return this.createGherkinCriteria(criteriaType, previousLine, line, line);
    }

    private GherkinCriteria createGherkinCriteria(String criteriaType, String previousLine, String line, String annotationLine) {
        boolean haveTags;
        GherkinCriteria criteria = new GherkinCriteria(criteriaType, line, annotationLine);
        boolean bl = haveTags = previousLine != null && !previousLine.isEmpty() && previousLine.startsWith("@");
        if (haveTags) {
            String[] tags;
            for (String tag : tags = previousLine.split(" ")) {
                criteria.addTag(tag.trim());
            }
        }
        return criteria;
    }

    private void fillExamplesMap(List<String> lines) {
        this.examplesContent = this.getExamplesContent(lines);
        if (this.examplesContent.size() > 1) {
            List<String> realKeys = this.putAndGetExamplesMapKeys(this.examplesValues);
            for (int i = 1; i < this.examplesContent.size(); ++i) {
                String examplesLine = this.examplesContent.get(i);
                String[] values = examplesLine.split("\\|");
                this.putExamplesMapValues(this.examplesValues, realKeys, values);
            }
        }
    }

    private List<String> putAndGetExamplesMapKeys(Map<String, List<GherkinVariable>> gherkinVariables) {
        ArrayList<String> realKeys = new ArrayList<String>();
        String header = this.examplesContent.get(0);
        String[] keys = header.split("\\|");
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i].trim();
            if (key.isEmpty()) continue;
            gherkinVariables.put("<" + key + ">", new ArrayList());
            realKeys.add(key);
        }
        return realKeys;
    }

    private void putExamplesMapValues(Map<String, List<GherkinVariable>> gherkinVariables, List<String> realKeys, String[] values) {
        int countKey = 0;
        for (int j = 1; j < values.length; ++j) {
            String value = values[j].trim();
            if (value.isEmpty()) continue;
            String key = realKeys.get(countKey);
            GherkinVariable variable = new GherkinVariable(key, value);
            gherkinVariables.get("<" + key + ">").add(variable);
            ++countKey;
        }
    }

    private List<String> getExamplesContent(List<String> lines) {
        ArrayList<String> examplesContent = new ArrayList<String>();
        boolean takeExamplesContent = false;
        for (String line : lines) {
            if ((line = this.clearLine(line)).isEmpty()) continue;
            boolean isCriteriaLine = line.startsWith(EXAMPLES);
            if (takeExamplesContent) {
                examplesContent.add(line);
            }
            if (isCriteriaLine) {
                takeExamplesContent = true;
                continue;
            }
            takeExamplesContent = line.startsWith("Scenario");
            takeExamplesContent |= line.startsWith(AND);
            takeExamplesContent |= line.startsWith("Given");
            takeExamplesContent |= line.startsWith("When");
            takeExamplesContent = !(takeExamplesContent |= line.startsWith("Then"));
        }
        return examplesContent;
    }

    private String clearLine(String line) {
        String clearedLine = "";
        if (line != null && !line.isEmpty()) {
            clearedLine = this.clearLineForAnnotation(line);
            clearedLine = Normalizer.normalize(clearedLine, Normalizer.Form.NFD);
            clearedLine = clearedLine.replaceAll("[^\\p{ASCII}]", "");
        }
        return clearedLine;
    }

    private String clearLineForAnnotation(String line) {
        String clearedLine = "";
        if (line != null && !line.isEmpty()) {
            clearedLine = line.trim();
            clearedLine = clearedLine.replaceAll("\"", "\\\"");
            clearedLine = clearedLine.replaceAll("'", "\\'");
            clearedLine = clearedLine.replaceAll("\n", "");
            clearedLine = clearedLine.replaceAll("\t", "");
        }
        return clearedLine;
    }

    public List<GherkinVariable> getVariablesInCriteria(String line) {
        ArrayList<GherkinVariable> listOfVariables = new ArrayList<GherkinVariable>();
        if (!line.isEmpty()) {
            String[] tokens;
            for (String token : tokens = line.split(" ")) {
                GherkinVariable variable = this.getFirstGherkinVariable(token);
                if (variable == null) continue;
                listOfVariables.add(variable);
            }
        }
        return listOfVariables;
    }

    private GherkinVariable getFirstGherkinVariable(String key) {
        List<GherkinVariable> list;
        GherkinVariable variable = null;
        if ((key = key.trim()).contains("<") && key.contains(">") && (list = this.examplesValues.get(key)) != null && !list.isEmpty()) {
            variable = list.get(0);
        }
        return variable;
    }

    public static String getMethodName(String criteria) {
        String methodName = "";
        if (!criteria.isEmpty()) {
            criteria = StringUtils.clearSpecialCharacters(criteria);
            String[] tokens = criteria.split(" ");
            tokens[0] = tokens[0].toLowerCase();
            if (tokens.length > 1) {
                for (int i = 1; i < tokens.length; ++i) {
                    tokens[i] = StringUtils.capitalizeWord(tokens[i]);
                }
            }
            methodName = StringUtils.concatArrayOfString(tokens, "");
        }
        return methodName;
    }

    public static String getAnnotationCriteria(String criteria) {
        return GherkinObject.getAnnotationCriteria(criteria, null);
    }

    public static String getAnnotationCriteria(String criteria, Map<String, List<GherkinVariable>> gherkinVariables) {
        String annotationCriteria = "";
        String splitter = "x01102332x";
        String clearedCriteria = GherkinObject.clearCriteria(criteria, splitter);
        String finalCriteria = GherkinObject.constructAnnotationCriteria(clearedCriteria, gherkinVariables, splitter);
        if (!finalCriteria.isEmpty()) {
            annotationCriteria = "\"^" + finalCriteria + "$\"";
        }
        return annotationCriteria;
    }

    private static String clearCriteria(String criteria, String splitter) {
        String clearedCriteria = "";
        clearedCriteria = criteria.replaceAll("<", splitter);
        clearedCriteria = clearedCriteria.replaceAll(">", splitter);
        return clearedCriteria;
    }

    private static String constructAnnotationCriteria(String clearedCriteria, Map<String, List<GherkinVariable>> gherkinVariables, String splitter) {
        String finalCriteria = "";
        String[] auxCriteria = clearedCriteria.split(splitter);
        StringBuilder stringBuilder = new StringBuilder();
        for (String aux : auxCriteria) {
            String key = "<" + aux + ">";
            List<GherkinVariable> listOfVariables = gherkinVariables.get(key);
            if (listOfVariables != null && !listOfVariables.isEmpty()) {
                String regex = "([^\\\"]*)";
                stringBuilder.append(regex);
                continue;
            }
            aux = aux.replaceAll("\"", "\\\\\"");
            stringBuilder.append(aux);
        }
        finalCriteria = stringBuilder.toString();
        return finalCriteria;
    }

    public String getFirstTestTag() {
        String tag = "";
        if (this.scenario != null) {
            tag = this.getTagKey(this.scenario.getFirstTag());
        }
        return tag;
    }

    public String getFirstTestPlanTag() {
        String tag = "";
        if (this.feature != null) {
            tag = this.getTagKey(this.feature.getFirstTag());
        }
        return tag;
    }

    private String getTagKey(String dirtyTag) {
        String[] tagSplited;
        String tag = "";
        if (dirtyTag != null && !dirtyTag.isEmpty() && (tagSplited = dirtyTag.split("_")) != null && tagSplited.length > 0) {
            for (int i = 1; i < tagSplited.length; ++i) {
                tag = tag + tagSplited[i];
            }
        }
        return tag;
    }
}

