/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.marcperez06.java_utilities.reflection.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GsonUtils {
    public static final String ESCAPING_HTML = "escaping html";
    public static final String NOT_ESCAPING_HTML = "Not escaping html";

    private GsonUtils() {
    }

    private static Gson createGson(String type, String dateFormat) {
        Gson gson = null;
        gson = type.equals(ESCAPING_HTML) ? (dateFormat != null ? new GsonBuilder().setDateFormat(dateFormat).create() : new Gson()) : (type.equals(NOT_ESCAPING_HTML) ? (dateFormat != null ? new GsonBuilder().setDateFormat(dateFormat).disableHtmlEscaping().create() : new GsonBuilder().disableHtmlEscaping().create()) : new Gson());
        return gson;
    }

    public static <T> T returnJsonObject(String json, Class<T> type) {
        return GsonUtils.returnJsonObject(json, type, null);
    }

    public static <T> T returnJsonObject(String json, Class<T> type, String dateFormat) {
        Object jsonObject = null;
        try {
            Gson gson = GsonUtils.createGson(ESCAPING_HTML, dateFormat);
            jsonObject = gson.fromJson(json, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            jsonObject = null;
        }
        return (T)jsonObject;
    }

    public static <T> List<T> returnJsonObjectList(String json, Class<T> type) {
        return GsonUtils.returnJsonObjectList(json, type, null);
    }

    public static <T> List<T> returnJsonObjectList(String json, Class<T> type, String dateFormat) {
        ArrayList<Object> jsonObjectList = new ArrayList<Object>();
        try {
            if (json != null && !json.isEmpty()) {
                List jsonObject = GsonUtils.returnJsonObject(json, List.class, dateFormat);
                if (jsonObject instanceof List) {
                    List list = jsonObject;
                    for (Object object : list) {
                        if (object instanceof Map) {
                            Map map = (Map)object;
                            T obj = ReflectionUtils.getSimpleObjectByMap(map, type);
                            jsonObjectList.add(obj);
                            continue;
                        }
                        jsonObjectList.add(object);
                    }
                } else {
                    jsonObjectList.add(jsonObject);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObjectList;
    }

    public static <T> T returnJsonObjectWithoutEscapingHtml(String json, Class<T> type) {
        return GsonUtils.returnJsonObjectWithoutEscapingHtml(json, type, null);
    }

    public static <T> T returnJsonObjectWithoutEscapingHtml(String json, Class<T> type, String dateFormat) {
        Object jsonObject = null;
        try {
            Gson gson = GsonUtils.createGson(NOT_ESCAPING_HTML, dateFormat);
            jsonObject = gson.fromJson(json, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            jsonObject = null;
        }
        return (T)jsonObject;
    }

    public static <T> List<T> returnJsonObjectListWithoutEscapingHtml(String json, Class<T> type) {
        return GsonUtils.returnJsonObjectList(json, type, null);
    }

    public static <T> List<T> returnJsonObjectListWithoutEscapingHtml(String json, Class<T> type, String dateFormat) {
        ArrayList<Object> jsonObjectList = new ArrayList<Object>();
        try {
            if (json != null && !json.isEmpty()) {
                List jsonObject = GsonUtils.returnJsonObjectWithoutEscapingHtml(json, List.class, dateFormat);
                if (jsonObject instanceof List) {
                    List list = jsonObject;
                    for (Object object : list) {
                        if (object instanceof Map) {
                            Map map = (Map)object;
                            T obj = ReflectionUtils.getSimpleObjectByMap(map, type);
                            jsonObjectList.add(obj);
                            continue;
                        }
                        jsonObjectList.add(object);
                    }
                } else {
                    jsonObjectList.add(jsonObject);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObjectList;
    }

    public static <T> String getJSON(T obj) {
        return GsonUtils.getJSON(obj, null);
    }

    public static <T> String getJSON(T obj, String dateFormat) {
        String json = "";
        try {
            boolean isInstanceOfString = obj instanceof String;
            if (obj != null && !isInstanceOfString) {
                Gson gson = GsonUtils.createGson(NOT_ESCAPING_HTML, dateFormat);
                json = gson.toJson(obj);
            } else if (obj != null && isInstanceOfString) {
                json = (String)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            json = "";
        }
        return json;
    }
}

