/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.numbers;

import java.text.NumberFormat;
import java.util.Locale;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class NumberUtils {
    private NumberUtils() {
    }

    public static String transformEuropeanToAmericanFormat(String number) {
        String americanNumber = "";
        if (number != null && !number.isEmpty()) {
            String[] numberParts = number.split("\\,");
            americanNumber = numberParts != null && numberParts.length > 1 ? numberParts[0].replaceAll("\\.", "") + "." + numberParts[1] : numberParts[0];
        }
        return americanNumber;
    }

    public static String transformAmericanToEuropeanFormat(String number) {
        String europeanNumber = "";
        if (number != null && !number.isEmpty()) {
            String[] numberParts = number.split("\\.");
            europeanNumber = numberParts != null && numberParts.length > 1 ? numberParts[0].replaceAll("\\,", "") + "," + numberParts[1] : numberParts[0];
        }
        return europeanNumber;
    }

    public static double evaluateMathExpression(String expression) {
        double result = 0.0;
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("js");
        expression = NumberUtils.replaceArithmeticFormula(expression);
        try {
            Object jsResult = scriptEngine.eval(expression);
            if (jsResult != null) {
                result = Double.valueOf(jsResult.toString());
            }
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String replaceArithmeticFormula(String expression) {
        expression = expression.replaceAll("sin", "Math.sin").replaceAll("cos", "Math.cos").replaceAll("tan", "Math.tan").replaceAll("sqrt", "Math.sqrt").replaceAll("log", "Math.log").replaceAll("log10", "Math.log10").replaceAll("pi", "Math.PI").replaceAll("round", "Math.round").replaceAll("ceil", "Math.ceil").replaceAll("floor", "Math.floor").replaceAll("abs", "Math.abs").replaceAll("random", "Math.random").replaceAll("max", "Math.max").replaceAll("min", "Math.min").replaceAll("pow", "Math.pow").replaceAll("exp", "Math.exp");
        return expression;
    }

    public static String toEuropeanFormat(double number) {
        return NumberUtils.toEuropeanFormat(number, 2);
    }

    public static String toEuropeanFormat(double number, int decimals) {
        NumberFormat formatter = NumberFormat.getInstance(Locale.ITALIAN);
        formatter.setMinimumFractionDigits(decimals);
        formatter.setMaximumFractionDigits(decimals);
        String numberFormatted = formatter.format(number);
        return numberFormatted;
    }

    public static String toAmericanFormat(double number) {
        return NumberUtils.toAmericanFormat(number, 2);
    }

    public static String toAmericanFormat(double number, int decimals) {
        NumberFormat formatter = NumberFormat.getInstance(Locale.US);
        formatter.setMinimumFractionDigits(decimals);
        formatter.setMaximumFractionDigits(decimals);
        String numberFormatted = formatter.format(number);
        return numberFormatted;
    }
}

