/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.reflection;

import com.google.gson.internal.LinkedTreeMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T, K, V> T getSimpleObjectByMap(Map<K, V> map, Class<T> type) {
        T obj = null;
        List<T> list = ReflectionUtils.getListOfSimpleObjectByMap(map, type);
        if (!list.isEmpty()) {
            obj = list.get(0);
        }
        return obj;
    }

    public static <T, K, V> List<T> getListOfSimpleObjectByMap(Map<K, V> map, Class<T> type) {
        ArrayList<T> list = new ArrayList<T>();
        int size = ReflectionUtils.getMaxSizeOfValueListByMap(map);
        try {
            for (int count = 0; count < size; ++count) {
                T obj = ReflectionUtils.createSimpleObjectByMap(map, type, count);
                if (obj == null) continue;
                list.add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static <K, V> int getMaxSizeOfValueListByMap(Map<K, V> map) {
        int size = 0;
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<K, V> mapEntry : map.entrySet()) {
                int currentSize = ReflectionUtils.getCurrentSizeOfValueList(mapEntry.getValue());
                if (currentSize <= size) continue;
                size = currentSize;
            }
        }
        return size;
    }

    private static <T, V> int getCurrentSizeOfValueList(T mapValue) {
        int currentSize = 0;
        if (mapValue instanceof List) {
            List listOfValues = (List)mapValue;
            if (listOfValues != null && !listOfValues.isEmpty()) {
                Object auxVal = listOfValues.get(0);
                currentSize = auxVal instanceof LinkedHashMap || auxVal instanceof LinkedTreeMap ? 1 : listOfValues.size();
            }
        } else if (mapValue != null) {
            currentSize = 1;
        }
        return currentSize;
    }

    private static <T, K, V> T createSimpleObjectByMap(Map<K, V> map, Class<T> type, int count) {
        T obj = null;
        int index = count;
        try {
            List<Field> fields = ReflectionUtils.getAllFieldsInClass(type);
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            obj = constructor.newInstance(new Object[0]);
            for (Field field : fields) {
                field.setAccessible(true);
                if (Modifier.isFinal(field.getModifiers())) continue;
                String key = field.getName();
                List<V> listOfValues = new ArrayList();
                if (map.get(key) instanceof List) {
                    listOfValues = (List)map.get(key);
                    index = count;
                } else {
                    V val = map.get(key);
                    listOfValues.add(val);
                    index = 0;
                }
                ReflectionUtils.fillFieldWithValues(obj, field, listOfValues, index);
            }
        }
        catch (Exception e) {
            obj = null;
            e.printStackTrace();
        }
        return obj;
    }

    public static <T, V> void fillFieldWithValues(T obj, Field field, List<V> listOfValues) {
        ReflectionUtils.fillFieldWithValues(obj, field, listOfValues, 0);
    }

    private static <T, V> void fillFieldWithValues(T obj, Field field, List<V> listOfValues, int index) {
        V value = null;
        try {
            if (listOfValues != null && !listOfValues.isEmpty() && index < listOfValues.size()) {
                value = listOfValues.get(index);
            }
            if (field.getType().isAssignableFrom(List.class) && value instanceof Map) {
                ReflectionUtils.fillFieldWithListOfLinkedHashMap(field, obj, listOfValues);
            } else if (field.getType().isAssignableFrom(Map.class) && value instanceof Map) {
                Map map = (Map)value;
                field.set(obj, map);
            } else if (field.getType().isAssignableFrom(List.class)) {
                field.set(obj, listOfValues);
            } else if (value instanceof Map) {
                ReflectionUtils.fillFieldWithObjcetOfLinkedHashMap(field, obj, listOfValues);
            } else {
                ReflectionUtils.fillFieldWithValue(obj, field, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T, V> void fillFieldWithListOfLinkedHashMap(Field field, T obj, List<V> listOfValues) {
        try {
            Class<?> typeOfClass = ReflectionUtils.getGenericTypeOfField(field);
            ArrayList list = new ArrayList();
            for (V mapValue : listOfValues) {
                Map auxMap = (Map)mapValue;
                Object simpleObj = ReflectionUtils.getSimpleObjectByMap(auxMap, typeOfClass);
                list.add(simpleObj);
            }
            field.set(obj, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T, V> void fillFieldWithObjcetOfLinkedHashMap(Field field, T obj, List<V> listOfValues) {
        try {
            Class<?> typeOfClass = ReflectionUtils.getGenericTypeOfField(field);
            Map auxMap = (Map)listOfValues.get(0);
            Object simpleObj = ReflectionUtils.getSimpleObjectByMap(auxMap, typeOfClass);
            field.set(obj, simpleObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T, V> void fillFieldWithValue(T obj, Field field, V value) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if (field.getType().isPrimitive()) {
            ReflectionUtils.fillFieldWithPrimitiveValue(obj, field, value);
        } else {
            ReflectionUtils.fillFieldWithoutPrimitiveValue(obj, field, value);
        }
    }

    private static <T, V> void fillFieldWithPrimitiveValue(T obj, Field field, V value) {
        String strValue = "";
        if (value != null) {
            strValue = String.valueOf(value);
        }
        try {
            if (value == null) {
                if (field.getType().isAssignableFrom(Number.class)) {
                    field.set(obj, 0);
                } else if (field.getType().isAssignableFrom(Boolean.class)) {
                    field.set(obj, false);
                }
            } else if (field.getType().isAssignableFrom(Integer.TYPE)) {
                String[] splitValue = strValue.split("\\.");
                String intValue = splitValue[0];
                field.set(obj, Integer.valueOf(intValue));
            } else if (field.getType().isAssignableFrom(Float.TYPE)) {
                field.set(obj, Float.valueOf(Float.valueOf(strValue).floatValue()));
            } else if (field.getType().isAssignableFrom(Double.TYPE)) {
                field.set(obj, (double)Double.valueOf(strValue));
            } else if (field.getType().isAssignableFrom(Long.TYPE)) {
                field.set(obj, (long)Long.valueOf(strValue));
            } else if (field.getType().isAssignableFrom(Short.TYPE)) {
                field.set(obj, (short)Short.valueOf(strValue));
            } else if (field.getType().isAssignableFrom(Boolean.TYPE)) {
                field.set(obj, (boolean)Boolean.valueOf(strValue));
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static <T, V> void fillFieldWithoutPrimitiveValue(T obj, Field field, V value) {
        String strValue = "";
        if (value != null) {
            strValue = String.valueOf(value);
        }
        try {
            if (value == null) {
                field.set(obj, value);
            } else if (field.getType().isAssignableFrom(String.class)) {
                field.set(obj, String.valueOf(value));
            } else if (field.getType().isAssignableFrom(Integer.class)) {
                String[] splitValue = strValue.split("\\.");
                String intValue = splitValue[0];
                field.set(obj, Integer.valueOf(intValue));
            } else if (field.getType().isAssignableFrom(Float.class)) {
                field.set(obj, Float.valueOf(strValue));
            } else if (field.getType().isAssignableFrom(Double.class)) {
                field.set(obj, Double.valueOf(strValue));
            } else if (field.getType().isAssignableFrom(Long.class)) {
                field.set(obj, Long.valueOf(strValue));
            } else if (field.getType().isAssignableFrom(Boolean.class)) {
                field.set(obj, Boolean.valueOf(strValue));
            } else if (field.getType().isAssignableFrom(URI.class)) {
                field.set(obj, URI.create(strValue));
            } else {
                field.set(obj, value);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static String getGenericClassNameOfField(Field field) {
        String className = "Not have class";
        Class<?> typeOfClass = ReflectionUtils.getGenericTypeOfField(field);
        if (typeOfClass != null) {
            className = typeOfClass.getSimpleName();
        }
        return className;
    }

    public static Class<?> getGenericTypeOfField(Field field) {
        Class<?> genericType = null;
        List<Class<?>> listOfTypes = ReflectionUtils.getGenericTypesOfField(field);
        if (!listOfTypes.isEmpty()) {
            genericType = listOfTypes.get(0);
        }
        return genericType;
    }

    public static List<Class<?>> getGenericTypesOfField(Field field) {
        ArrayList listOfTypes = new ArrayList();
        if (field != null) {
            Class<?> typeOfClass = field.getType();
            try {
                Type fieldType = field.getGenericType();
                if (fieldType instanceof ParameterizedType) {
                    ParameterizedType genericType = (ParameterizedType)fieldType;
                    Class<?> actualClassArgument = ReflectionUtils.getGenericClassOfParameterizedType(genericType);
                    if (actualClassArgument != null) {
                        listOfTypes.add(actualClassArgument);
                    }
                } else {
                    listOfTypes.add(typeOfClass);
                }
            }
            catch (Exception e) {
                System.out.println("Field --> " + field.getName());
                e.printStackTrace();
            }
        }
        return listOfTypes;
    }

    private static Class<?> getGenericClassOfParameterizedType(ParameterizedType parameterizedType) {
        Class<?> genericClass = null;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        try {
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                if (!(actualTypeArguments[i] instanceof ParameterizedType)) {
                    String className = actualTypeArguments[i].getTypeName();
                    genericClass = Class.forName(className);
                    continue;
                }
                ParameterizedType auxParameterizedType = (ParameterizedType)actualTypeArguments[i];
                genericClass = ReflectionUtils.getGenericClassOfParameterizedType(auxParameterizedType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return genericClass;
    }

    public static Class<?> getGenericParameterOfClass(Class<?> genericClass) {
        Class<?> genericParameter = null;
        List<Class<?>> listOfTypes = ReflectionUtils.getGenericParametersOfClass(genericClass);
        if (!listOfTypes.isEmpty()) {
            genericParameter = listOfTypes.get(0);
        }
        return genericParameter;
    }

    public static List<Class<?>> getGenericParametersOfClass(Class<?> genericClass) {
        List<Class<?>> listOfTypes = new ArrayList();
        Field fieldParameterizedType = ReflectionUtils.getField("parameterizedType", genericClass);
        Class<?> parameterizedTypesOfClass = ReflectionUtils.getGenericTypeOfField(fieldParameterizedType);
        Class<?> type = genericClass;
        if (type != null) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)((Object)type);
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length > 0) {
                    for (int i = 0; i < actualTypeArguments.length; ++i) {
                        try {
                            String className = actualTypeArguments[i].getTypeName();
                            Class<?> actualClassParameter = Class.forName(className);
                            listOfTypes.add(actualClassParameter);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            } else {
                Class superClass = (Class)genericClass.getGenericSuperclass();
                listOfTypes = ReflectionUtils.getGenericParametersOfClass(superClass);
            }
        } else {
            listOfTypes.add(parameterizedTypesOfClass);
        }
        return listOfTypes;
    }

    public static <T> Field getField(String fieldName, T obj) {
        Field field = obj != null ? ReflectionUtils.getField(fieldName, obj.getClass()) : null;
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Field getField(String fieldName, Class<T> clazz) {
        Field field = null;
        if (clazz != null) {
            try {
                field = ReflectionUtils.getDeclaredField(fieldName, clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (field != null) {
                    field.setAccessible(true);
                }
            }
        }
        return field;
    }

    private static <T> Field getDeclaredField(String fieldName, Class<T> clazz) {
        Field field = null;
        try {
            boolean isNotObjectClass;
            boolean bl = isNotObjectClass = !clazz.getName().equals("java.lang.Object");
            if (isNotObjectClass) {
                field = clazz.getDeclaredField(fieldName);
                if (field == null) {
                    field = ReflectionUtils.getField(fieldName, clazz.getSuperclass());
                }
            } else {
                field = null;
            }
        }
        catch (NoSuchFieldException e) {
            field = ReflectionUtils.getField(fieldName, clazz.getSuperclass());
        }
        catch (Exception e) {
            e.printStackTrace();
            field = null;
        }
        return field;
    }

    public static <T> List<Field> getFieldsOfObject(T obj) {
        List<Field> fields = new ArrayList<Field>();
        if (obj != null) {
            fields = ReflectionUtils.getFieldsOfClass(obj.getClass());
        }
        return fields;
    }

    public static List<Field> getFieldsOfClass(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        try {
            Field[] classFields = clazz.getDeclaredFields();
            fields.addAll(Arrays.asList(classFields));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fields;
    }

    public static <T> List<Field> getAllFieldsInObject(T obj) {
        List<Field> fields = new ArrayList<Field>();
        if (obj != null) {
            fields = ReflectionUtils.getAllFieldsInClass(obj.getClass());
        }
        return fields;
    }

    public static List<Field> getAllFieldsInClass(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        try {
            for (Class parentClass = clazz.getSuperclass(); parentClass != null && !parentClass.getName().equals("java.lang.Object"); parentClass = parentClass.getSuperclass()) {
                fields.addAll(ReflectionUtils.getFieldsOfClass(parentClass));
            }
            fields.addAll(ReflectionUtils.getFieldsOfClass(clazz));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fields;
    }

    public static <T, V> V getFieldValue(T object, String fieldName) {
        Object value = null;
        Field field = ReflectionUtils.getField(fieldName, object);
        if (field != null) {
            try {
                value = field.get(object);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (V)value;
    }

    public static List<Field> getAnnotatedDeclaredFields(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        List<Field> allFields = ReflectionUtils.getFieldsOfClass(clazz);
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        if (allFields != null) {
            for (Field field : allFields) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                annotatedFields.add(field);
            }
        }
        return annotatedFields;
    }

    public static <T, V> T findObjectInList(List<T> list, String fieldName, V value) {
        T obj = null;
        boolean found = false;
        try {
            if (list != null) {
                for (int i = 0; i < list.size() && !found; ++i) {
                    T object = list.get(i);
                    Field field = ReflectionUtils.getField(fieldName, object.getClass());
                    if (field == null || !(found = field.get(object).equals(value))) continue;
                    obj = object;
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static <T, V> T findObjectInArray(T[] array, String fieldName, V value) {
        T obj = null;
        boolean found = false;
        try {
            if (array != null) {
                for (int i = 0; i < array.length && !found; ++i) {
                    T object = array[i];
                    Field field = ReflectionUtils.getField(fieldName, object.getClass());
                    if (field == null || !(found = field.get(object).equals(value))) continue;
                    obj = object;
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static <T, V> List<T> findObjectsInList(List<T> list, String fieldName, V value) {
        ArrayList<T> foundObjects = new ArrayList<T>();
        boolean found = false;
        try {
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    T object = list.get(i);
                    Field field = ReflectionUtils.getField(fieldName, object.getClass());
                    if (field == null || !(found = field.get(object).equals(value))) continue;
                    foundObjects.add(object);
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return foundObjects;
    }

    public static <T, V> List<T> findObjectsInArray(T[] array, String fieldName, V value) {
        ArrayList<T> foundObjects = new ArrayList<T>();
        boolean found = false;
        try {
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    T object = array[i];
                    Field field = object.getClass().getField(fieldName);
                    if (field == null || !(found = field.get(object).equals(value))) continue;
                    foundObjects.add(object);
                }
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return foundObjects;
    }

    public static <T> T cloneObject(T obj) {
        T clone = null;
        if (obj != null) {
            try {
                Class<?> clazz = obj.getClass();
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                clone = (T)constructor.newInstance(new Object[0]);
                List<Field> fields = ReflectionUtils.getAllFieldsInClass(clazz);
                for (Field field : fields) {
                    field.setAccessible(true);
                    ReflectionUtils.fillFieldWithValue(clone, field, field.get(obj));
                    field.setAccessible(false);
                }
            }
            catch (Exception e) {
                clone = null;
            }
        }
        return clone;
    }

    public static <T> boolean haveSameProperties(T objA, T objB) {
        boolean haveSameProperties = false;
        haveSameProperties = objA == null;
        if (!(haveSameProperties &= objB == null)) {
            haveSameProperties = ReflectionUtils.allFieldsAreEquals(objA, objB);
        }
        return haveSameProperties;
    }

    private static <T> boolean allFieldsAreEquals(T objA, T objB) {
        boolean notAreNull;
        boolean allFieldsAreEquals = false;
        boolean bl = notAreNull = objA != null && objB != null;
        if (notAreNull) {
            allFieldsAreEquals = true;
            Field[] fields = objA.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length && allFieldsAreEquals; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                allFieldsAreEquals = ReflectionUtils.fieldAreEquals(field, objA, objB);
            }
        }
        return allFieldsAreEquals;
    }

    private static <T> boolean fieldAreEquals(Field field, T objA, T objB) {
        boolean areEqual = false;
        try {
            if (field.get(objA) != null) {
                areEqual = field.get(objA).equals(field.get(objB));
            } else if (field.get(objB) != null) {
                areEqual = field.get(objB).equals(field.get(objA));
            } else {
                areEqual = field.get(objA) == null;
                areEqual &= field.get(objB) == null;
            }
        }
        catch (IllegalArgumentException e) {
            areEqual = false;
        }
        catch (IllegalAccessException e) {
            areEqual = false;
        }
        return areEqual;
    }

    public static <T> Map<String, Object> getMapFromObject(T obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Field> allFields = ReflectionUtils.getAllFieldsInObject(obj);
        for (Field field : allFields) {
            field.setAccessible(true);
            try {
                map.put(field.getName(), field.get(obj));
            }
            catch (IllegalArgumentException e) {
                map.put(field.getName(), null);
            }
            catch (IllegalAccessException e) {
                map.put(field.getName(), null);
            }
        }
        return map;
    }

    public static <T, O> O transform(T objectA, Class<O> classB) {
        Object obj = null;
        try {
            Constructor<O> constructor = classB.getConstructor(new Class[0]);
            obj = constructor.newInstance(new Object[0]);
            if (objectA != null) {
                List<Field> fieldsObjectA = ReflectionUtils.getAllFieldsInObject(objectA);
                for (Field fieldA : fieldsObjectA) {
                    ReflectionUtils.fillTheSameFieldOfDifferentObjects(fieldA, objectA, obj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            obj = null;
        }
        return (O)obj;
    }

    private static <A, B> void fillTheSameFieldOfDifferentObjects(Field fieldA, A objectA, B objectB) throws Exception {
        String fieldAName = fieldA.getName();
        Class<?> classFieldA = ReflectionUtils.getGenericTypeOfField(fieldA);
        fieldA.setAccessible(true);
        Field fieldB = ReflectionUtils.getField(fieldAName, objectB);
        if (fieldB != null) {
            String fieldBName = fieldB.getName();
            Class<?> classFieldB = ReflectionUtils.getGenericTypeOfField(fieldB);
            boolean isTheSameField = fieldAName.equals(fieldBName);
            if (isTheSameField &= classFieldA.equals(classFieldB)) {
                ReflectionUtils.fillFieldWithValue(objectB, fieldB, fieldA.get(objectA));
            }
        }
    }

    public static <T> Method getMethod(T object, String name, Class<?> ... parameterTypes) {
        Method method = null;
        if (object != null) {
            Class<?> clazz = object.getClass();
            method = ReflectionUtils.getMethod(clazz, name, parameterTypes);
        }
        return method;
    }

    public static <T> Method getMethod(Class<T> clazz, String name, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
        }
        catch (Exception e) {
            method = null;
            e.printStackTrace();
        }
        return method;
    }

    public static <T> List<Method> getAllMethods(T object) {
        List<Method> methods = new ArrayList<Method>();
        if (object != null) {
            Class<?> clazz = object.getClass();
            methods = ReflectionUtils.getAllMethods(clazz);
        }
        return methods;
    }

    public static <T> List<Method> getAllMethods(Class<T> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        try {
            for (Class<T> parentClass = clazz.getSuperclass(); parentClass != null && !parentClass.getName().equals("java.lang.Object"); parentClass = parentClass.getSuperclass()) {
                methods.addAll(ReflectionUtils.getMethodsOfClass(parentClass));
            }
            methods.addAll(ReflectionUtils.getMethodsOfClass(clazz));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return methods;
    }

    public static List<Method> getMethodsOfClass(Class clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        try {
            Method[] classMethods = clazz.getDeclaredMethods();
            methods.addAll(Arrays.asList(classMethods));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return methods;
    }

    public static <T> void printObjectProperties(T object) {
        if (object != null) {
            try {
                Class<?> clazz = object.getClass();
                String className = clazz.getCanonicalName();
                if (!clazz.isPrimitive() && !clazz.getName().equals("java.lang.Object")) {
                    System.out.println("-------------------------------------------------------------------------");
                    System.out.println("Class Name: " + className);
                    System.out.println("Class Package: " + clazz.getPackage().getName());
                    System.out.println("------------------------- " + className + " Properties ----------------------------");
                    List<Field> fields = ReflectionUtils.getAllFieldsInClass(clazz);
                    for (Field field : fields) {
                        String packageName;
                        if (field == null) continue;
                        field.setAccessible(true);
                        String fieldName = field.getName();
                        Class<?> fieldClass = ReflectionUtils.getGenericTypeOfField(field);
                        Package packageObj = fieldClass.getPackage();
                        String string = packageName = packageObj != null ? packageObj.getName() : "None";
                        Object fieldValue = field.get(object);
                        if (fieldValue == null) continue;
                        System.out.println("-------------------------------------------------------------------------");
                        System.out.println("Field Name: " + fieldName);
                        System.out.println("Field Class: " + fieldClass.getCanonicalName());
                        System.out.println("Field Class Package: " + packageName);
                        if (String.class.isInstance(fieldValue) || Number.class.isInstance(fieldValue) || Map.class.isInstance(fieldValue) || fieldClass.isArray()) {
                            System.out.println("Field Value: " + String.valueOf(fieldValue));
                        } else if (!clazz.isPrimitive()) {
                            ReflectionUtils.printObjectProperties(fieldValue);
                        }
                        System.out.println("-------------------------------------------------------------------------");
                    }
                } else {
                    System.out.println("-------------------------------------------------------------------------");
                    System.out.println("Is a primitive class --> " + className);
                    System.out.println("-------------------------------------------------------------------------");
                }
                System.out.println("-------------------------------------------------------------------------");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Object you want info is NULL");
        }
    }
}

