/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.servlets;

import javax.servlet.http.HttpServletRequest;

public class ServletUtilities {
    private ServletUtilities() {
    }

    public static String headWithTitle(String title) {
        return "<!DOCTYPE html>\n<html>\n<head><title>" + title + "</title></head>\n";
    }

    public static int getIntParameter(HttpServletRequest request, String paramName, int defaultValue) {
        int paramValue;
        String paramString = request.getParameter(paramName);
        try {
            paramValue = Integer.parseInt(paramString);
        }
        catch (Exception nfe) {
            paramValue = defaultValue;
        }
        return paramValue;
    }

    public static double getDoubleParameter(HttpServletRequest request, String paramName, double defaultValue) {
        double paramValue;
        String paramString = request.getParameter(paramName);
        try {
            paramValue = Double.parseDouble(paramString);
        }
        catch (Exception nfe) {
            paramValue = defaultValue;
        }
        return paramValue;
    }

    public static String filter(String input) {
        String filteredInput = input;
        if (ServletUtilities.hasSpecialChars(input)) {
            StringBuilder filtered = new StringBuilder(input.length());
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c == '<') {
                    filtered.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    filtered.append("&gt;");
                    continue;
                }
                if (c == '\"') {
                    filtered.append("&quot;");
                    continue;
                }
                if (c == '&') {
                    filtered.append("&amp;");
                    continue;
                }
                filtered.append(c);
            }
            filteredInput = filtered.toString();
        }
        return filteredInput;
    }

    private static boolean hasSpecialChars(String input) {
        boolean haveSpecialChar = false;
        if (input != null && !input.isEmpty()) {
            for (int i = 0; i < input.length() && !haveSpecialChar; ++i) {
                char c = input.charAt(i);
                if (c == '<') {
                    haveSpecialChar = true;
                    continue;
                }
                if (c == '>') {
                    haveSpecialChar = true;
                    continue;
                }
                if (c == '\"') {
                    haveSpecialChar = true;
                    continue;
                }
                if (c != '&') continue;
                haveSpecialChar = true;
            }
        }
        return haveSpecialChar;
    }
}

