/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.strings;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    private RegexUtils() {
    }

    public static String changeCharToWordRegex(String text, String character) {
        return RegexUtils.changeCharToRegex(text, character, "[a-zA-Z_.-]");
    }

    public static String changeCharToWordAndNumberRegex(String text, String character) {
        return RegexUtils.changeCharToRegex(text, character, "[a-zA-Z0-9_.-]");
    }

    public static String changeCharToNumericRegex(String text, String character) {
        return RegexUtils.changeCharToRegex(text, character, "[0-9]");
    }

    private static String changeCharToRegex(String text, String character, String regexForReplacement) {
        String newText = text;
        String regex = "[" + character + "]{1,}";
        while (text.matches(".*" + regex + ".*")) {
            String substring = RegexUtils.getSubstringUsingRegEx(newText, regex);
            regex = regexForReplacement + "{1," + substring.length() + "}";
            newText = newText.replaceFirst(substring, regex);
        }
        return newText;
    }

    public static String getSubstringUsingRegEx(String text, String regex) {
        String substring = "";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        MatchResult result = null;
        if (matcher.find()) {
            result = matcher.toMatchResult();
        }
        if (result == null) {
            throw new RuntimeException("Can not apply the regex '" + regex + "' to text '" + text + "'");
        }
        substring = text.substring(result.start(), result.end());
        return substring;
    }
}

