/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.timer;

import java.util.concurrent.TimeUnit;

public class Timer {
    private long startTime;
    private long endTime;

    public Timer() {
        this.setStartTime(0L);
        this.setEndTime(0L);
    }

    public long getStartTime() {
        return this.startTime;
    }

    private void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    private void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public long startTimer() {
        this.setStartTime(this.getCurrentTime());
        return this.startTime;
    }

    public long stopTimer() {
        this.setEndTime(this.getCurrentTime());
        return this.getTime();
    }

    public long getTime() {
        return this.endTime - this.startTime;
    }

    public long getTime(TimeUnit unit) {
        long time = this.getTime();
        return this.transformTimeToUnit(time, unit);
    }

    public long transformTimeToUnit(long durationInMilliseconds, TimeUnit unit) {
        TimeUnit sourceUnit = TimeUnit.MILLISECONDS;
        return this.transformTimeToUnit(durationInMilliseconds, sourceUnit, unit);
    }

    public long transformTimeToUnit(long duration, TimeUnit sourceUnit, TimeUnit destinationUnit) {
        return destinationUnit.convert(duration, sourceUnit);
    }
}

