/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.uri.endpoint;

import io.github.marcperez06.java_utilities.strings.StringUtils;
import java.util.Map;

public class Endpoint {
    private Endpoint() {
    }

    public static String build(String endPoint, String ... params) {
        return StringUtils.format(endPoint, params);
    }

    public static String build(String endPoint, Map<String, String> pathParams) {
        String uri = "";
        uri = Endpoint.buildUriWithPathParams(endPoint, pathParams);
        return uri;
    }

    private static String buildUriWithPathParams(String endPoint, Map<String, String> pathParams) {
        StringBuilder builder = new StringBuilder();
        builder.append(endPoint);
        if (pathParams != null && !pathParams.isEmpty()) {
            for (Map.Entry<String, String> param : pathParams.entrySet()) {
                String separator = "{" + param.getKey() + "}";
                int indexSeparator = builder.toString().indexOf(separator);
                int end = indexSeparator + separator.length();
                if (indexSeparator <= 0) continue;
                builder.replace(indexSeparator, end, param.getValue());
            }
        }
        return builder.toString();
    }
}

