/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.validation;

import io.github.marcperez06.java_utilities.collection.array.ArrayUtils;
import io.github.marcperez06.java_utilities.reflection.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ValidationUtils {
    public static final String REGEX_EMAIL = "^[A-Za-z](.*)([@]{1})(.{1,})(\\.)(.{1,})";

    private ValidationUtils() {
    }

    public static <T> boolean equals(T objA, T objB) {
        boolean areEquals = false;
        if (objA != null) {
            areEquals = ValidationUtils.equalsInherentOfClass(objA, objB);
        } else if (objB != null) {
            areEquals = ValidationUtils.equalsInherentOfClass(objB, objA);
        } else {
            areEquals = objA == null;
            areEquals &= objB == null;
        }
        return areEquals;
    }

    private static <T> boolean equalsInherentOfClass(T objA, T objB) {
        boolean areEquals = false;
        Class<?> clazz = null;
        Method equals = null;
        try {
            if (objA != null) {
                clazz = objA.getClass();
                equals = clazz.getDeclaredMethod("equals", clazz);
                equals.setAccessible(true);
                areEquals = (Boolean)equals.invoke(objA, objB);
            }
        }
        catch (NoSuchMethodException e) {
            areEquals = objA.equals(objB);
        }
        catch (Exception e) {
            areEquals = false;
        }
        return areEquals;
    }

    public static boolean equalsLowerCase(String a, String b) {
        String lowerA = a.toLowerCase();
        String lowerB = b.toLowerCase();
        return ValidationUtils.equals(lowerA, lowerB);
    }

    public static <T> boolean isNaN(T obj) {
        boolean result = true;
        try {
            if (obj instanceof Number) {
                result = false;
            }
        }
        catch (Exception e) {
            result = true;
        }
        return result;
    }

    public static <T> boolean isNotNaN(T obj) {
        return !ValidationUtils.isNaN(obj);
    }

    public static <T> boolean isNull(T obj) {
        boolean result = true;
        try {
            result = obj == null;
        }
        catch (Exception e) {
            result = true;
        }
        return result;
    }

    public static <T> boolean isNotNull(T obj) {
        return !ValidationUtils.isNull(obj);
    }

    public static <T> boolean isNotEmpty(T obj) {
        return !ValidationUtils.isEmpty(obj);
    }

    public static <T> boolean isEmpty(T obj) {
        boolean isEmpty = true;
        try {
            if (obj != null) {
                if (obj.getClass().isArray()) {
                    isEmpty = Array.getLength(obj) == 0;
                } else if (obj instanceof List) {
                    List list = (List)obj;
                    isEmpty = list.isEmpty();
                } else if (obj instanceof Map) {
                    Map map = (Map)obj;
                    isEmpty = map.isEmpty();
                } else if (obj instanceof String) {
                    String str = (String)obj;
                    isEmpty = str.isEmpty();
                } else {
                    isEmpty = false;
                }
            }
        }
        catch (Exception e) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public static <T> boolean haveMinimumLength(T obj, int length) {
        boolean haveMinimum = false;
        try {
            if (obj instanceof String) {
                if (((String)obj).length() <= length) {
                    haveMinimum = true;
                }
            } else if (obj instanceof List) {
                if (((List)obj).size() <= length) {
                    haveMinimum = true;
                }
            } else if (obj instanceof Map) {
                if (((Map)obj).size() <= length) {
                    haveMinimum = true;
                }
            } else if (obj instanceof Number && ((Number)obj).floatValue() <= (float)length) {
                haveMinimum = true;
            }
        }
        catch (Exception e) {
            haveMinimum = false;
            e.printStackTrace();
        }
        return haveMinimum;
    }

    public static <T> boolean haveMaxLength(T obj, int length) {
        boolean haveMax = false;
        try {
            if (obj instanceof String) {
                if (((String)obj).length() >= length) {
                    haveMax = true;
                }
            } else if (obj instanceof List) {
                if (((List)obj).size() >= length) {
                    haveMax = true;
                }
            } else if (obj instanceof Map) {
                if (((Map)obj).size() >= length) {
                    haveMax = true;
                }
            } else if (obj instanceof Number && ((Number)obj).floatValue() >= (float)length) {
                haveMax = true;
            }
        }
        catch (Exception e) {
            haveMax = false;
            e.printStackTrace();
        }
        return haveMax;
    }

    public static <T> boolean isBetweenLength(T obj, int min, int max) {
        boolean isBetween = false;
        try {
            if (obj instanceof String) {
                if (((String)obj).length() >= min && ((String)obj).length() <= max) {
                    isBetween = true;
                }
            } else if (obj instanceof List) {
                if (((List)obj).size() >= min && ((List)obj).size() <= max) {
                    isBetween = true;
                }
            } else if (obj instanceof Map) {
                if (((Map)obj).size() >= min && ((Map)obj).size() <= max) {
                    isBetween = true;
                }
            } else if (obj instanceof Number && ((Number)obj).floatValue() >= (float)min && ((Number)obj).floatValue() <= (float)max) {
                isBetween = true;
            }
        }
        catch (Exception e) {
            isBetween = false;
            e.printStackTrace();
        }
        return isBetween;
    }

    public static boolean isPatternMatches(String pattern, String txt) {
        return Pattern.matches(pattern, txt);
    }

    public static <T, V> boolean fieldNotHaveThisValue(T obj, String fieldName, V value) {
        boolean fieldNotHaveValue = false;
        Field field = null;
        try {
            Class<?> clazz;
            if (obj != null && (field = (clazz = obj.getClass()).getDeclaredField(fieldName)) != null) {
                field.setAccessible(true);
                fieldNotHaveValue = !ValidationUtils.equals(field.get(obj), value);
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            fieldNotHaveValue = false;
        }
        return fieldNotHaveValue;
    }

    public static <T, V> boolean fieldHaveThisValue(T obj, String fieldName, V value) {
        boolean fieldHaveValue = false;
        Field field = null;
        try {
            Class<?> clazz;
            if (obj != null && (field = (clazz = obj.getClass()).getDeclaredField(fieldName)) != null) {
                field.setAccessible(true);
                fieldHaveValue = ValidationUtils.equals(field.get(obj), value);
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            fieldHaveValue = false;
        }
        return fieldHaveValue;
    }

    public static <T> boolean modificationsAreCorrect(T objA, T objB, String ... fieldsModified) {
        boolean modificationsAreCorrect = false;
        boolean fieldError = false;
        try {
            if (ValidationUtils.canVerifyTheModifications(objA, objB, fieldsModified)) {
                Class<?> clazz = objA.getClass();
                Field[] fields = clazz.getDeclaredFields();
                for (int i = 0; i < fields.length && !fieldError; ++i) {
                    Field field = fields[i];
                    String fieldName = field.getName();
                    field.setAccessible(true);
                    fieldError = ArrayUtils.existObjectInArray(fieldsModified, fieldName) ? ValidationUtils.fieldValueIsEqual(field, objA, objB) : ValidationUtils.fieldValueIsNotEqual(field, objA, objB);
                    field.setAccessible(false);
                }
                if (!fieldError) {
                    modificationsAreCorrect = true;
                }
            }
        }
        catch (Exception e) {
            modificationsAreCorrect = false;
        }
        return modificationsAreCorrect;
    }

    private static <T> boolean canVerifyTheModifications(T objA, T objB, String[] fieldsModified) {
        boolean canVerifyTheModifications = fieldsModified != null;
        canVerifyTheModifications &= fieldsModified.length > 0;
        canVerifyTheModifications &= objA != null;
        return canVerifyTheModifications &= objB != null;
    }

    private static <T> boolean fieldValueIsNotEqual(Field field, T objA, T objB) {
        return !ValidationUtils.fieldValueIsEqual(field, objA, objB);
    }

    private static <T> boolean fieldValueIsEqual(Field field, T objA, T objB) {
        boolean isEqual = false;
        try {
            isEqual = ValidationUtils.equals(field.get(objA), field.get(objB));
        }
        catch (IllegalArgumentException e) {
            isEqual = false;
        }
        catch (IllegalAccessException e) {
            isEqual = false;
        }
        return isEqual;
    }

    public static <T, X> boolean objectIsOfType(T obj, Class<X> type) {
        boolean isOfType = false;
        try {
            isOfType = type.isInstance(obj);
        }
        catch (Exception e) {
            isOfType = false;
        }
        return isOfType;
    }

    public static <T, X> boolean listOfObjectAreOfType(List<T> objects, Class<X> type) {
        boolean areOfType = false;
        try {
            for (T obj : objects) {
                areOfType = type.isInstance(obj);
            }
        }
        catch (Exception e) {
            areOfType = false;
        }
        return areOfType;
    }

    public static <T, X> boolean objectAHaveSamePropertiesObjectB(T objA, X objB) {
        boolean haveSameProperties = false;
        try {
            boolean areNotNull;
            boolean bl = areNotNull = objA != null && objB != null;
            if (areNotNull) {
                Field fieldOfObjA;
                List<Field> objAFields = ReflectionUtils.getAllFieldsInObject(objA);
                haveSameProperties = !objAFields.isEmpty();
                for (int i = 0; i < objAFields.size() && haveSameProperties; haveSameProperties &= ValidationUtils.fieldHaveSameValueIgnoringNulls(fieldOfObjA, objA, objB), ++i) {
                    fieldOfObjA = objAFields.get(i);
                }
            } else {
                haveSameProperties = true;
            }
        }
        catch (Exception e) {
            haveSameProperties = false;
        }
        return haveSameProperties;
    }

    private static <T, X> boolean fieldHaveSameValueIgnoringNulls(Field field, T objA, X objB) {
        boolean haveSameValue = false;
        field.setAccessible(true);
        try {
            haveSameValue = field.get(objA) != null ? ValidationUtils.fieldValueIsEqual(field, objA, objB) : true;
        }
        catch (Exception e) {
            haveSameValue = false;
        }
        field.setAccessible(false);
        return haveSameValue;
    }

    public static <T> boolean objPropertiesNotHaveValue(T obj) {
        boolean isEmpty = false;
        try {
            Class<?> clazz = Class.forName(obj.getClass().getName());
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length && !isEmpty; ++i) {
                Field field = fields[i];
                if (field.get(obj) instanceof String || field.get(obj) instanceof List || field.get(obj) instanceof Map) {
                    isEmpty = ValidationUtils.isEmpty(obj);
                    continue;
                }
                if (!ValidationUtils.isNull(field.get(obj))) continue;
                isEmpty = true;
            }
        }
        catch (Exception e) {
            isEmpty = true;
        }
        return isEmpty;
    }
}

