/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.xml;

import java.io.File;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    private XmlUtils() {
    }

    public static Document getXmlDocumentFromFile(String path) {
        Document doc = null;
        File file = new File(path);
        if (file != null) {
            try {
                doc = XmlUtils.getXmlDocumentFromUrl(file.toURI().toURL().toString());
            }
            catch (MalformedURLException e) {
                doc = null;
                e.printStackTrace();
            }
        }
        return doc;
    }

    public static Document getXmlDocumentFromUrl(String urlString) {
        Document doc = null;
        try {
            URL url = new URL(urlString);
            URLConnection conn = url.openConnection();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(conn.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static NodeList getNodeListFromUrl(String url, String nodeName) {
        NodeList nodeList = null;
        Document doc = XmlUtils.getXmlDocumentFromUrl(url);
        if (doc != null) {
            nodeList = doc.getElementsByTagName(nodeName);
        }
        return nodeList;
    }

    public static String getNodeValueFromUrl(String url, String nodeName) {
        String value = "";
        List<String> valueList = XmlUtils.getNodesValueFromUrl(url, nodeName);
        if (valueList.size() > 0) {
            value = valueList.get(0);
        }
        return value;
    }

    public static List<String> getNodesValueFromUrl(String url, String nodeName) {
        NodeList nodeList = XmlUtils.getNodeListFromUrl(url, nodeName);
        List<String> valueList = XmlUtils.getNodesValue(nodeList);
        return valueList;
    }

    public static String getNodeValue(Node node) {
        String nodeValue = null;
        List<String> nodeValues = XmlUtils.getNodeValues(node);
        if (nodeValues.size() > 0) {
            nodeValue = nodeValues.get(0).trim().replaceAll("\n", "");
        }
        return nodeValue;
    }

    public static List<String> getNodesValue(NodeList nodeList) {
        ArrayList<String> valueList = new ArrayList<String>();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                List<String> auxList = XmlUtils.getNodeValues(node);
                valueList.addAll(auxList);
            }
        }
        return valueList;
    }

    public static List<String> getNodeValues(Node node) {
        String nodeValue = "";
        ArrayList<String> valueList = new ArrayList<String>();
        if (node != null) {
            if (node.getNodeType() == 3) {
                nodeValue = node.getTextContent();
                if (!nodeValue.isEmpty()) {
                    valueList.add(nodeValue);
                }
            } else {
                NodeList childNodes = node.getChildNodes();
                List<String> childValueList = XmlUtils.getNodesValue(childNodes);
                valueList.addAll(childValueList);
            }
        }
        return valueList;
    }

    public static Map<String, List<String>> getTextNodesValuesFromUrl(String url) {
        Document document = XmlUtils.getXmlDocumentFromUrl(url);
        NodeList nodeList = document.getChildNodes();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        XmlUtils.fillMapWithNodeList(nodeList, map);
        return map;
    }

    public static Map<String, List<String>> getTextNodesValuesFromFile(String path) {
        Document document = XmlUtils.getXmlDocumentFromFile(path);
        NodeList nodeList = document.getChildNodes();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        XmlUtils.fillMapWithNodeList(nodeList, map);
        return map;
    }

    private static void fillMapWithNodeList(NodeList nodeList, Map<String, List<String>> map) {
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 3) {
                    XmlUtils.fillMapWithTextNodesValue(node, map);
                    continue;
                }
                NodeList childNodes = node.getChildNodes();
                XmlUtils.fillMapWithNodeList(childNodes, map);
            }
        }
    }

    private static void fillMapWithTextNodesValue(Node node, Map<String, List<String>> map) {
        if (node != null) {
            String parentName = node.getParentNode().getNodeName();
            String nodeValue = XmlUtils.getNodeValue(node);
            List<String> nodeValues = map.get(parentName);
            if (nodeValues != null && !nodeValue.isEmpty()) {
                nodeValues.add(nodeValue);
            } else {
                ArrayList<String> newNodeValues = new ArrayList<String>();
                if (!nodeValue.isEmpty()) {
                    newNodeValues.add(nodeValue);
                }
                map.put(parentName, newNodeValues);
            }
        }
    }

    public static String getNodeAttribute(Node node, String attributeName) {
        boolean founded = false;
        String attributeValue = "";
        NamedNodeMap attributesMap = node.getAttributes();
        for (int i = 0; i < attributesMap.getLength() && !founded; ++i) {
            Node attribute = attributesMap.item(i);
            if (!attributeName.equals(attribute.getNodeName())) continue;
            attributeValue = attribute.getTextContent();
            founded = true;
        }
        return attributeValue;
    }

    public static Node getFirstChildNodeByName(Node parentNode, String childName) {
        boolean founded = false;
        Node childNode = null;
        NodeList nodeList = parentNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && !founded; ++i) {
            Node auxNode;
            Node currentChild = nodeList.item(i);
            if (currentChild.getNodeName().equals(childName)) {
                childNode = currentChild;
                founded = true;
                continue;
            }
            if (currentChild.getChildNodes().getLength() <= 0 || (auxNode = XmlUtils.getFirstChildNodeByName(currentChild, childName)) == null) continue;
            childNode = auxNode;
            founded = true;
        }
        return childNode;
    }

    public static String convertDocumentToString(Document doc) {
        String output = null;
        Transformer transformer = XmlUtils.createTransformerWithoutXmlDeclaration();
        StringWriter writer = new StringWriter();
        if (transformer != null) {
            try {
                DOMSource domSource = new DOMSource(doc);
                StreamResult streamResult = new StreamResult(writer);
                transformer.transform(domSource, streamResult);
                output = writer.getBuffer().toString();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    private static Transformer createTransformerWithoutXmlDeclaration() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
        }
        catch (TransformerConfigurationException e) {
            transformer = null;
            e.printStackTrace();
        }
        return transformer;
    }

    public static String generateHtmlUsingXslt(String xmlPath, String xsltPath) {
        String html = "";
        File xmlFile = new File(xmlPath);
        File xsltFile = new File(xsltPath);
        StringWriter writer = new StringWriter();
        StreamResult streamResult = new StreamResult(writer);
        if (xmlFile.exists() && xsltFile.exists()) {
            StreamSource xml = new StreamSource(xmlFile);
            StreamSource xslt = new StreamSource(xsltFile);
            try {
                TransformerFactory transformFactory = TransformerFactory.newInstance();
                Transformer trasform = transformFactory.newTransformer(xslt);
                trasform.transform(xml, streamResult);
                html = writer.toString();
            }
            catch (TransformerException e) {
                html = "";
                e.printStackTrace();
            }
        }
        return html;
    }
}

