/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbridge.outbound;

import io.github.kbridge.outbound.InternalGateway;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.stereotype.Component;

@Component
public class KafkaOutboundImpl {
    private static final Logger log = LoggerFactory.getLogger(KafkaOutboundImpl.class);
    @Autowired
    private InternalGateway internalGateway;

    @ServiceActivator(inputChannel="toKafkaChannel")
    public void toKafkaHandler(GenericMessage<ProducerRecord<String, Object>> message) {
        log.debug("received from toKafkaChannel: {} ", message.getPayload());
        this.internalGateway.sendToKafka(message);
        log.debug("sent to kafka: {} ", (Object)((ProducerRecord)message.getPayload()).topic());
    }
}

