/*
 * Decompiled with CFR 0.152.
 */
package io.github.md2java.service;

import io.github.md2java.anno.LogMethodInfo;
import io.github.md2java.service.MethodLogger;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MethodLoggerImpl
implements MethodLogger {
    private static final Logger log = LoggerFactory.getLogger(MethodLoggerImpl.class);

    @Override
    public Object logMethod(ProceedingJoinPoint pjp) throws Throwable {
        LogMethodInfo logMethodInfo = this.findLogMethodInfo(pjp);
        long startTime = System.currentTimeMillis();
        if (logMethodInfo.logRequest()) {
            log.info("==> Method:{} request:{}", (Object)pjp.getSignature().toShortString(), (Object)Arrays.toString(pjp.getArgs()));
        }
        Object ret = pjp.proceed();
        if (logMethodInfo.logResponse()) {
            log.info("==< Method:{} response:{}", (Object)pjp.getSignature().toShortString(), ret);
        }
        if (logMethodInfo.logTime()) {
            log.info("##method={}##execution-time={}ms", (Object)pjp.getSignature().toShortString(), (Object)(System.currentTimeMillis() - startTime));
        }
        return ret;
    }

    private LogMethodInfo findLogMethodInfo(ProceedingJoinPoint pjp) {
        Method method = this.findMethod(pjp);
        LogMethodInfo myAnnotation = method.getAnnotation(LogMethodInfo.class);
        return myAnnotation;
    }

    private Method findMethod(ProceedingJoinPoint pjp) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        return method;
    }
}

