/*
 * Decompiled with CFR 0.152.
 */
package io.github.microapplet.remote.net.netty;

import io.github.microapplet.remote.net.netty.context.RemoteNettyChannelContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.EmptyByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyPoolUtil {
    private static final Logger log = LoggerFactory.getLogger(NettyPoolUtil.class);

    public static void get(Promise<?> future, CountDownLatch countDownLatch, int timeout) {
        if (!future.isDone() && !future.isDone()) {
            try {
                boolean await = countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
                if (!await) {
                    future.setFailure((Throwable)new TimeoutException("\u7b49\u5f85\u8d85\u65f6\uff0c\u6700\u5927\u5141\u8bb8\u8d85\u65f6\u65f6\u95f4\uff1a" + timeout + "\u6beb\u79d2"));
                }
            }
            catch (Throwable t) {
                future.setFailure((Throwable)new TimeoutException("\u7b49\u5f85\u8d85\u65f6\uff0c\u6700\u5927\u5141\u8bb8\u8d85\u65f6\u65f6\u95f4\uff1a" + timeout + "\u6beb\u79d2"));
            }
        }
        if (future.isSuccess()) {
            future.getNow();
        }
    }

    public static void releaseNettyClient(SimpleChannelPool simpleChannelPool, Future<Channel> future) {
        Channel channel = (Channel)future.getNow();
        if (Objects.isNull(channel)) {
            return;
        }
        ChannelFuture channelFuture = channel.closeFuture();
        channelFuture.addListener(future1 -> simpleChannelPool.release(channel));
    }

    public static void releaseChannel(ChannelHandlerContext ctx) {
        block9: {
            if (Objects.isNull(ctx) || Objects.isNull(ctx.channel())) {
                return;
            }
            try {
                RemoteNettyChannelContext nettyHttpRequestContext = (RemoteNettyChannelContext)ctx.channel().attr(RemoteNettyChannelContext.CURRENT_REQ_BOUND_WITH_THE_CHANNEL).get();
                if (Objects.isNull(nettyHttpRequestContext)) {
                    return;
                }
                SimpleChannelPool simpleChannelPool = nettyHttpRequestContext.getSimpleChannelPool();
                if (Objects.nonNull(simpleChannelPool)) {
                    simpleChannelPool.release(ctx.channel());
                } else {
                    ctx.channel().close();
                }
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug("Release Netty Channel Exception Happen: {}", (Object)t.getMessage(), (Object)t);
                }
                try {
                    ctx.channel().close();
                }
                catch (Throwable ex) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug("Close Netty Channel Exception Happen: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
    }

    public static void releaseObject(Object ... args) {
        if (ArrayUtils.isEmpty((Object[])args)) {
            return;
        }
        for (Object arg : args) {
            if (arg instanceof Collection) {
                NettyPoolUtil.releaseObject((Collection)arg);
                continue;
            }
            NettyPoolUtil.doRelease(args);
        }
    }

    public static void releaseObject(Collection<Object> args) {
        if (CollectionUtils.isEmpty(args)) {
            return;
        }
        for (Object arg : args) {
            if (arg instanceof Collection) {
                NettyPoolUtil.releaseObject((Collection)arg);
                continue;
            }
            NettyPoolUtil.doRelease(arg);
        }
    }

    private static void doRelease(Object arg) {
        block13: {
            try {
                ByteBuf content;
                if (Objects.isNull(arg)) {
                    return;
                }
                if (!(arg instanceof ReferenceCounted)) break block13;
                ReferenceCounted counted = (ReferenceCounted)arg;
                int i = counted.refCnt();
                if (log.isDebugEnabled()) {
                    log.debug("Release Reference: {} Counted: {}", (Object)counted.getClass().getName(), (Object)i);
                }
                if (i <= 0) {
                    return;
                }
                if (counted instanceof EmptyByteBuf) {
                    ReferenceCountUtil.safeRelease((Object)counted, (int)i);
                    if (log.isDebugEnabled()) {
                        log.debug("Release EmptyByteBuf Reference: {} Counted: {}, Number: 0 Result:{}", new Object[]{counted.getClass().getName(), i, true});
                    }
                    return;
                }
                if (counted instanceof ByteBufHolder && (content = ((ByteBufHolder)counted).content()) instanceof EmptyByteBuf) {
                    ReferenceCountUtil.safeRelease((Object)counted, (int)i);
                    if (log.isDebugEnabled()) {
                        log.debug("Release EmptyByteBufHolder Reference: {} Counted: {}, Number: 0 Result:{}", new Object[]{counted.getClass().getName(), i, true});
                    }
                    return;
                }
                try {
                    boolean release = ReferenceCountUtil.release((Object)counted, (int)i);
                    if (log.isDebugEnabled()) {
                        log.info("Release Reference: {} Counted: {} Number: {} Result: {}", new Object[]{counted.getClass().getName(), i, counted.refCnt(), release});
                    }
                }
                catch (Throwable t) {
                    if (log.isDebugEnabled()) {
                        log.info("Release Reference: {} Counted: {} Exception Happen: {}", new Object[]{counted.getClass().getName(), i, t.getMessage(), t});
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

