/*
 * Decompiled with CFR 0.152.
 */
package io.github.microapplet.remote.net.netty.context;

import io.github.microapplet.remote.context.GenericKey;
import io.github.microapplet.remote.context.RemoteReqContext;
import io.github.microapplet.remote.context.RemoteResContext;
import io.github.microapplet.remote.thread.NamedThreadFactory;
import io.netty.channel.Channel;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;

public class RemoteNettyChannelContext {
    public static final AttributeKey<RemoteNettyChannelContext> CURRENT_REQ_BOUND_WITH_THE_CHANNEL = AttributeKey.valueOf((String)"CURRENT_REQ_BOUND_WITH_THE_CHANNEL");
    public static final GenericKey<Promise<?>> DEFAULT_PROMISE_RES_CONTEXT_KEY = GenericKey.keyOf((String)"DEFAULT_PROMISE_RES_CONTEXT_KEY");
    public static final GenericKey<Boolean> REQUEST_SEND = GenericKey.keyOf((String)"SEND_NET_REQUEST");
    public static final ThreadFactory REMOTE_EVENT_LOOP_GROUP = new NamedThreadFactory("RELG");
    public static final ThreadFactory REMOTE_EVENT_LOOP_RESULT = new NamedThreadFactory("RELR");
    public static final EventLoopGroup group = new NioEventLoopGroup(0, REMOTE_EVENT_LOOP_GROUP);
    public static final DefaultEventLoop NETTY_RESPONSE_PROMISE_NOTIFY_EVENT_LOOP = new DefaultEventLoop(group, REMOTE_EVENT_LOOP_RESULT);
    private Channel channel;
    private RemoteReqContext reqContext;
    private RemoteResContext resContext;
    private SimpleChannelPool simpleChannelPool;
    private Promise<?> defaultPromise;
    private SSLContext sslContext;
    private String trace;

    public static RemoteNettyChannelContextBuilder builder() {
        return new RemoteNettyChannelContextBuilder();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public RemoteReqContext getReqContext() {
        return this.reqContext;
    }

    public RemoteResContext getResContext() {
        return this.resContext;
    }

    public SimpleChannelPool getSimpleChannelPool() {
        return this.simpleChannelPool;
    }

    public Promise<?> getDefaultPromise() {
        return this.defaultPromise;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setReqContext(RemoteReqContext reqContext) {
        this.reqContext = reqContext;
    }

    public void setResContext(RemoteResContext resContext) {
        this.resContext = resContext;
    }

    public void setSimpleChannelPool(SimpleChannelPool simpleChannelPool) {
        this.simpleChannelPool = simpleChannelPool;
    }

    public void setDefaultPromise(Promise<?> defaultPromise) {
        this.defaultPromise = defaultPromise;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteNettyChannelContext)) {
            return false;
        }
        RemoteNettyChannelContext other = (RemoteNettyChannelContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        RemoteReqContext this$reqContext = this.getReqContext();
        RemoteReqContext other$reqContext = other.getReqContext();
        if (this$reqContext == null ? other$reqContext != null : !this$reqContext.equals(other$reqContext)) {
            return false;
        }
        RemoteResContext this$resContext = this.getResContext();
        RemoteResContext other$resContext = other.getResContext();
        if (this$resContext == null ? other$resContext != null : !this$resContext.equals(other$resContext)) {
            return false;
        }
        SimpleChannelPool this$simpleChannelPool = this.getSimpleChannelPool();
        SimpleChannelPool other$simpleChannelPool = other.getSimpleChannelPool();
        if (this$simpleChannelPool == null ? other$simpleChannelPool != null : !this$simpleChannelPool.equals(other$simpleChannelPool)) {
            return false;
        }
        Promise<?> this$defaultPromise = this.getDefaultPromise();
        Promise<?> other$defaultPromise = other.getDefaultPromise();
        if (this$defaultPromise == null ? other$defaultPromise != null : !this$defaultPromise.equals(other$defaultPromise)) {
            return false;
        }
        SSLContext this$sslContext = this.getSslContext();
        SSLContext other$sslContext = other.getSslContext();
        if (this$sslContext == null ? other$sslContext != null : !this$sslContext.equals(other$sslContext)) {
            return false;
        }
        String this$trace = this.getTrace();
        String other$trace = other.getTrace();
        return !(this$trace == null ? other$trace != null : !this$trace.equals(other$trace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteNettyChannelContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        RemoteReqContext $reqContext = this.getReqContext();
        result = result * 59 + ($reqContext == null ? 43 : $reqContext.hashCode());
        RemoteResContext $resContext = this.getResContext();
        result = result * 59 + ($resContext == null ? 43 : $resContext.hashCode());
        SimpleChannelPool $simpleChannelPool = this.getSimpleChannelPool();
        result = result * 59 + ($simpleChannelPool == null ? 43 : $simpleChannelPool.hashCode());
        Promise<?> $defaultPromise = this.getDefaultPromise();
        result = result * 59 + ($defaultPromise == null ? 43 : $defaultPromise.hashCode());
        SSLContext $sslContext = this.getSslContext();
        result = result * 59 + ($sslContext == null ? 43 : $sslContext.hashCode());
        String $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : $trace.hashCode());
        return result;
    }

    public String toString() {
        return "RemoteNettyChannelContext(channel=" + this.getChannel() + ", reqContext=" + this.getReqContext() + ", resContext=" + this.getResContext() + ", simpleChannelPool=" + this.getSimpleChannelPool() + ", defaultPromise=" + this.getDefaultPromise() + ", sslContext=" + this.getSslContext() + ", trace=" + this.getTrace() + ")";
    }

    public RemoteNettyChannelContext() {
    }

    public RemoteNettyChannelContext(Channel channel, RemoteReqContext reqContext, RemoteResContext resContext, SimpleChannelPool simpleChannelPool, Promise<?> defaultPromise, SSLContext sslContext, String trace) {
        this.channel = channel;
        this.reqContext = reqContext;
        this.resContext = resContext;
        this.simpleChannelPool = simpleChannelPool;
        this.defaultPromise = defaultPromise;
        this.sslContext = sslContext;
        this.trace = trace;
    }

    public static class RemoteNettyChannelContextBuilder {
        private Channel channel;
        private RemoteReqContext reqContext;
        private RemoteResContext resContext;
        private SimpleChannelPool simpleChannelPool;
        private Promise<?> defaultPromise;
        private SSLContext sslContext;
        private String trace;

        RemoteNettyChannelContextBuilder() {
        }

        public RemoteNettyChannelContextBuilder channel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public RemoteNettyChannelContextBuilder reqContext(RemoteReqContext reqContext) {
            this.reqContext = reqContext;
            return this;
        }

        public RemoteNettyChannelContextBuilder resContext(RemoteResContext resContext) {
            this.resContext = resContext;
            return this;
        }

        public RemoteNettyChannelContextBuilder simpleChannelPool(SimpleChannelPool simpleChannelPool) {
            this.simpleChannelPool = simpleChannelPool;
            return this;
        }

        public RemoteNettyChannelContextBuilder defaultPromise(Promise<?> defaultPromise) {
            this.defaultPromise = defaultPromise;
            return this;
        }

        public RemoteNettyChannelContextBuilder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public RemoteNettyChannelContextBuilder trace(String trace) {
            this.trace = trace;
            return this;
        }

        public RemoteNettyChannelContext build() {
            return new RemoteNettyChannelContext(this.channel, this.reqContext, this.resContext, this.simpleChannelPool, this.defaultPromise, this.sslContext, this.trace);
        }

        public String toString() {
            return "RemoteNettyChannelContext.RemoteNettyChannelContextBuilder(channel=" + this.channel + ", reqContext=" + this.reqContext + ", resContext=" + this.resContext + ", simpleChannelPool=" + this.simpleChannelPool + ", defaultPromise=" + this.defaultPromise + ", sslContext=" + this.sslContext + ", trace=" + this.trace + ")";
        }
    }
}

