/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.microcks.client.ApiException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class KeycloakClient {
    private static final Log log = LogFactory.getLog(KeycloakClient.class);

    private KeycloakClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String connectAndGetOAuthToken(String serviceAccount, String saCredentials, String tokenEndpoint) throws ApiException, IOException {
        CloseableHttpClient httpClient = null;
        try {
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            httpClient = HttpClients.custom().setSSLHostnameVerifier((s, sslSession) -> true).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (GeneralSecurityException gse) {
            log.error((Object)"Caught a SecurityException when building the SSL Context", (Throwable)gse);
            throw new ApiException("SSLContext cannot be created to reach Keycloak endpoint: " + gse.getMessage());
        }
        try {
            HttpPost tokenRequest = new HttpPost(tokenEndpoint);
            tokenRequest.addHeader("Content-Type", "application/x-www-form-urlencoded");
            tokenRequest.addHeader("Accept", "application/json");
            tokenRequest.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((serviceAccount + ":" + saCredentials).getBytes(StandardCharsets.UTF_8)));
            tokenRequest.setEntity((HttpEntity)new StringEntity("grant_type=client_credentials"));
            CloseableHttpResponse tokenResponse = httpClient.execute((HttpUriRequest)tokenRequest);
            if (tokenResponse.getStatusLine().getStatusCode() != 200) {
                log.error((Object)"OAuth token cannot be retrieved for Keycloak server, check serviceaccount configuration");
                log.error((Object)("  tokenResponse.statusLine: " + tokenResponse.getStatusLine().toString()));
                log.error((Object)("  tokenResponse.statusCode: " + tokenResponse.getStatusLine().getStatusCode()));
                throw new ApiException("OAuth token cannot be retrieved for Microcks. Check serviceaccount.");
            }
            String result = EntityUtils.toString((HttpEntity)tokenResponse.getEntity());
            log.debug((Object)("Result: " + result));
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonToken = mapper.readTree(result);
            String string = jsonToken.path("access_token").asText();
            return string;
        }
        finally {
            httpClient.close();
        }
    }
}

