/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"clientId", "clientSecret", "tokenUri", "username", "password", "refreshToken"})
public class OAuth2ClientContent {
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "clientSecret";
    private String clientSecret;
    public static final String JSON_PROPERTY_TOKEN_URI = "tokenUri";
    private String tokenUri;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refreshToken";
    private String refreshToken;

    public OAuth2ClientContent clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuth2ClientContent clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nonnull
    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuth2ClientContent tokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tokenUri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTokenUri() {
        return this.tokenUri;
    }

    @JsonProperty(value="tokenUri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
    }

    public OAuth2ClientContent username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public OAuth2ClientContent password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public OAuth2ClientContent refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="refreshToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @JsonProperty(value="refreshToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientContent oauth2ClientContent = (OAuth2ClientContent)o;
        return Objects.equals(this.clientId, oauth2ClientContent.clientId) && Objects.equals(this.clientSecret, oauth2ClientContent.clientSecret) && Objects.equals(this.tokenUri, oauth2ClientContent.tokenUri) && Objects.equals(this.username, oauth2ClientContent.username) && Objects.equals(this.password, oauth2ClientContent.password) && Objects.equals(this.refreshToken, oauth2ClientContent.refreshToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.tokenUri, this.username, this.password, this.refreshToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientContent {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append("*").append("\n");
        sb.append("    tokenUri: ").append(this.toIndentedString(this.tokenUri)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getClientId() != null) {
            joiner.add(String.format("%sclientId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getClientId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getClientSecret() != null) {
            joiner.add(String.format("%sclientSecret%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getClientSecret()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTokenUri() != null) {
            joiner.add(String.format("%stokenUri%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTokenUri()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUsername() != null) {
            joiner.add(String.format("%susername%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getUsername()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPassword() != null) {
            joiner.add(String.format("%spassword%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getPassword()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRefreshToken() != null) {
            joiner.add(String.format("%srefreshToken%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getRefreshToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

