/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.Binding;
import io.github.microcks.client.model.ParameterConstraint;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "method", "inputName", "outputName", "dispatcher", "dispatcherRules", "defaultDelay", "resourcePaths", "parameterContraints", "bindings"})
public class Operation {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;
    public static final String JSON_PROPERTY_INPUT_NAME = "inputName";
    private String inputName;
    public static final String JSON_PROPERTY_OUTPUT_NAME = "outputName";
    private String outputName;
    public static final String JSON_PROPERTY_DISPATCHER = "dispatcher";
    private String dispatcher;
    public static final String JSON_PROPERTY_DISPATCHER_RULES = "dispatcherRules";
    private String dispatcherRules;
    public static final String JSON_PROPERTY_DEFAULT_DELAY = "defaultDelay";
    private BigDecimal defaultDelay;
    public static final String JSON_PROPERTY_RESOURCE_PATHS = "resourcePaths";
    private List<String> resourcePaths = new ArrayList<String>();
    public static final String JSON_PROPERTY_PARAMETER_CONTRAINTS = "parameterContraints";
    private List<ParameterConstraint> parameterContraints = new ArrayList<ParameterConstraint>();
    public static final String JSON_PROPERTY_BINDINGS = "bindings";
    private Map<String, Binding> bindings = new HashMap<String, Binding>();

    public Operation name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Operation method(String method) {
        this.method = method;
        return this;
    }

    @Nonnull
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMethod(String method) {
        this.method = method;
    }

    public Operation inputName(String inputName) {
        this.inputName = inputName;
        return this;
    }

    @Nullable
    @JsonProperty(value="inputName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputName() {
        return this.inputName;
    }

    @JsonProperty(value="inputName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public Operation outputName(String outputName) {
        this.outputName = outputName;
        return this;
    }

    @Nullable
    @JsonProperty(value="outputName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOutputName() {
        return this.outputName;
    }

    @JsonProperty(value="outputName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public Operation dispatcher(String dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    @Nullable
    @JsonProperty(value="dispatcher")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDispatcher() {
        return this.dispatcher;
    }

    @JsonProperty(value="dispatcher")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDispatcher(String dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Operation dispatcherRules(String dispatcherRules) {
        this.dispatcherRules = dispatcherRules;
        return this;
    }

    @Nullable
    @JsonProperty(value="dispatcherRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDispatcherRules() {
        return this.dispatcherRules;
    }

    @JsonProperty(value="dispatcherRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDispatcherRules(String dispatcherRules) {
        this.dispatcherRules = dispatcherRules;
    }

    public Operation defaultDelay(BigDecimal defaultDelay) {
        this.defaultDelay = defaultDelay;
        return this;
    }

    @Nullable
    @JsonProperty(value="defaultDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getDefaultDelay() {
        return this.defaultDelay;
    }

    @JsonProperty(value="defaultDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultDelay(BigDecimal defaultDelay) {
        this.defaultDelay = defaultDelay;
    }

    public Operation resourcePaths(List<String> resourcePaths) {
        this.resourcePaths = resourcePaths;
        return this;
    }

    public Operation addResourcePathsItem(String resourcePathsItem) {
        if (this.resourcePaths == null) {
            this.resourcePaths = new ArrayList<String>();
        }
        this.resourcePaths.add(resourcePathsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="resourcePaths")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getResourcePaths() {
        return this.resourcePaths;
    }

    @JsonProperty(value="resourcePaths")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourcePaths(List<String> resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    public Operation parameterContraints(List<ParameterConstraint> parameterContraints) {
        this.parameterContraints = parameterContraints;
        return this;
    }

    public Operation addParameterContraintsItem(ParameterConstraint parameterContraintsItem) {
        if (this.parameterContraints == null) {
            this.parameterContraints = new ArrayList<ParameterConstraint>();
        }
        this.parameterContraints.add(parameterContraintsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="parameterContraints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ParameterConstraint> getParameterContraints() {
        return this.parameterContraints;
    }

    @JsonProperty(value="parameterContraints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameterContraints(List<ParameterConstraint> parameterContraints) {
        this.parameterContraints = parameterContraints;
    }

    public Operation bindings(Map<String, Binding> bindings) {
        this.bindings = bindings;
        return this;
    }

    public Operation putBindingsItem(String key, Binding bindingsItem) {
        if (this.bindings == null) {
            this.bindings = new HashMap<String, Binding>();
        }
        this.bindings.put(key, bindingsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="bindings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Binding> getBindings() {
        return this.bindings;
    }

    @JsonProperty(value="bindings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBindings(Map<String, Binding> bindings) {
        this.bindings = bindings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operation operation = (Operation)o;
        return Objects.equals(this.name, operation.name) && Objects.equals(this.method, operation.method) && Objects.equals(this.inputName, operation.inputName) && Objects.equals(this.outputName, operation.outputName) && Objects.equals(this.dispatcher, operation.dispatcher) && Objects.equals(this.dispatcherRules, operation.dispatcherRules) && Objects.equals(this.defaultDelay, operation.defaultDelay) && Objects.equals(this.resourcePaths, operation.resourcePaths) && Objects.equals(this.parameterContraints, operation.parameterContraints) && Objects.equals(this.bindings, operation.bindings);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.method, this.inputName, this.outputName, this.dispatcher, this.dispatcherRules, this.defaultDelay, this.resourcePaths, this.parameterContraints, this.bindings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Operation {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    inputName: ").append(this.toIndentedString(this.inputName)).append("\n");
        sb.append("    outputName: ").append(this.toIndentedString(this.outputName)).append("\n");
        sb.append("    dispatcher: ").append(this.toIndentedString(this.dispatcher)).append("\n");
        sb.append("    dispatcherRules: ").append(this.toIndentedString(this.dispatcherRules)).append("\n");
        sb.append("    defaultDelay: ").append(this.toIndentedString(this.defaultDelay)).append("\n");
        sb.append("    resourcePaths: ").append(this.toIndentedString(this.resourcePaths)).append("\n");
        sb.append("    parameterContraints: ").append(this.toIndentedString(this.parameterContraints)).append("\n");
        sb.append("    bindings: ").append(this.toIndentedString(this.bindings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMethod() != null) {
            joiner.add(String.format("%smethod%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getMethod()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInputName() != null) {
            joiner.add(String.format("%sinputName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getInputName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getOutputName() != null) {
            joiner.add(String.format("%soutputName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getOutputName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDispatcher() != null) {
            joiner.add(String.format("%sdispatcher%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDispatcher()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDispatcherRules() != null) {
            joiner.add(String.format("%sdispatcherRules%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDispatcherRules()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDefaultDelay() != null) {
            joiner.add(String.format("%sdefaultDelay%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDefaultDelay()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getResourcePaths() != null) {
            for (i = 0; i < this.getResourcePaths().size(); ++i) {
                joiner.add(String.format("%sresourcePaths%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(ApiClient.valueToString(this.getResourcePaths().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getParameterContraints() != null) {
            for (i = 0; i < this.getParameterContraints().size(); ++i) {
                if (this.getParameterContraints().get(i) == null) continue;
                joiner.add(this.getParameterContraints().get(i).toUrlQueryString(String.format("%sparameterContraints%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getBindings() != null) {
            for (String _key : this.getBindings().keySet()) {
                if (this.getBindings().get(_key) == null) continue;
                joiner.add(this.getBindings().get(_key).toUrlQueryString(String.format("%sbindings%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

