/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.Request;
import io.github.microcks.client.model.Response;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"type", "request", "response"})
public class RequestResponsePair {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private Request request;
    public static final String JSON_PROPERTY_RESPONSE = "response";
    private Response response;

    public RequestResponsePair type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RequestResponsePair request(Request request) {
        this.request = request;
        return this;
    }

    @Nonnull
    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Request getRequest() {
        return this.request;
    }

    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequest(Request request) {
        this.request = request;
    }

    public RequestResponsePair response(Response response) {
        this.response = response;
        return this;
    }

    @Nonnull
    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Response getResponse() {
        return this.response;
    }

    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResponse(Response response) {
        this.response = response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestResponsePair requestResponsePair = (RequestResponsePair)o;
        return Objects.equals((Object)this.type, (Object)requestResponsePair.type) && Objects.equals(this.request, requestResponsePair.request) && Objects.equals(this.response, requestResponsePair.response);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.request, this.response});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestResponsePair {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRequest() != null) {
            joiner.add(this.getRequest().toUrlQueryString((String)prefix + JSON_PROPERTY_REQUEST + suffix));
        }
        if (this.getResponse() != null) {
            joiner.add(this.getResponse().toUrlQueryString((String)prefix + JSON_PROPERTY_RESPONSE + suffix));
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        REQ_RESP_PAIR("reqRespPair"),
        UNIDIR_EVENT("unidirEvent");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

