/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.EventMessage;
import io.github.microcks.client.model.Request;
import io.github.microcks.client.model.Response;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"code", "elapsedTime", "message", "request", "response", "eventMessage"})
public class TestReturn {
    public static final String JSON_PROPERTY_CODE = "code";
    private Integer code;
    public static final String JSON_PROPERTY_ELAPSED_TIME = "elapsedTime";
    private Long elapsedTime;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private Request request;
    public static final String JSON_PROPERTY_RESPONSE = "response";
    private Response response;
    public static final String JSON_PROPERTY_EVENT_MESSAGE = "eventMessage";
    private EventMessage eventMessage;

    public TestReturn code(Integer code) {
        this.code = code;
        return this;
    }

    @Nonnull
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCode(Integer code) {
        this.code = code;
    }

    public TestReturn elapsedTime(Long elapsedTime) {
        this.elapsedTime = elapsedTime;
        return this;
    }

    @Nonnull
    @JsonProperty(value="elapsedTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty(value="elapsedTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setElapsedTime(Long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public TestReturn message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public TestReturn request(Request request) {
        this.request = request;
        return this;
    }

    @Nullable
    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Request getRequest() {
        return this.request;
    }

    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequest(Request request) {
        this.request = request;
    }

    public TestReturn response(Response response) {
        this.response = response;
        return this;
    }

    @Nullable
    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Response getResponse() {
        return this.response;
    }

    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponse(Response response) {
        this.response = response;
    }

    public TestReturn eventMessage(EventMessage eventMessage) {
        this.eventMessage = eventMessage;
        return this;
    }

    @Nullable
    @JsonProperty(value="eventMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventMessage getEventMessage() {
        return this.eventMessage;
    }

    @JsonProperty(value="eventMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventMessage(EventMessage eventMessage) {
        this.eventMessage = eventMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestReturn testReturn = (TestReturn)o;
        return Objects.equals(this.code, testReturn.code) && Objects.equals(this.elapsedTime, testReturn.elapsedTime) && Objects.equals(this.message, testReturn.message) && Objects.equals(this.request, testReturn.request) && Objects.equals(this.response, testReturn.response) && Objects.equals(this.eventMessage, testReturn.eventMessage);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.elapsedTime, this.message, this.request, this.response, this.eventMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestReturn {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    elapsedTime: ").append(this.toIndentedString(this.elapsedTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("    eventMessage: ").append(this.toIndentedString(this.eventMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCode() != null) {
            joiner.add(String.format("%scode%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getElapsedTime() != null) {
            joiner.add(String.format("%selapsedTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getElapsedTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMessage() != null) {
            joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getMessage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRequest() != null) {
            joiner.add(this.getRequest().toUrlQueryString((String)prefix + JSON_PROPERTY_REQUEST + suffix));
        }
        if (this.getResponse() != null) {
            joiner.add(this.getResponse().toUrlQueryString((String)prefix + JSON_PROPERTY_RESPONSE + suffix));
        }
        if (this.getEventMessage() != null) {
            joiner.add(this.getEventMessage().toUrlQueryString((String)prefix + JSON_PROPERTY_EVENT_MESSAGE + suffix));
        }
        return joiner.toString();
    }
}

