/*
 * Copyright 2012-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.github.mikerasch.logback.adapter.spring.utils;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ClassUtils {

  public static Method getMethodIfAvailable(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
    if (paramTypes != null) {
      return getMethodOrNull(clazz, methodName, paramTypes);
    }
    else {
      Set<Method> candidates = findMethodCandidatesByName(clazz, methodName);
      if (candidates.size() == 1) {
        return candidates.iterator().next();
      }
      return null;
    }
  }

  private static Method getMethodOrNull(Class<?> clazz, String methodName, Class<?> [] paramTypes) {
    try {
      return clazz.getMethod(methodName, paramTypes);
    }
    catch (NoSuchMethodException ex) {
      return null;
    }
  }

  private static Set<Method> findMethodCandidatesByName(Class<?> clazz, String methodName) {
    Set<Method> candidates = new HashSet<>(1);
    Method[] methods = clazz.getMethods();
    for (Method method : methods) {
      if (methodName.equals(method.getName())) {
        candidates.add(method);
      }
    }
    return candidates;
  }
}
