/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikerasch.logback.adapter.spring;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.TurboFilterList;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import io.github.mikerasch.logback.adapter.spring.ansi.AnsiOutput;
import io.github.mikerasch.logback.adapter.spring.config.DefaultLogbackConfiguration;
import io.github.mikerasch.logback.adapter.spring.config.LogbackConfigurator;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.SubstituteLoggerFactory;

public class LogbackLoggingSystem {
    private final DefaultLogbackConfiguration defaultLogbackConfiguration = new DefaultLogbackConfiguration();
    private static final TurboFilter SUPPRESS_ALL_FILTER = new TurboFilter(){

        public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
            return FilterReply.DENY;
        }
    };

    public LogbackLoggingSystem() {
        AnsiOutput.configure();
    }

    public void loadDefaults() {
        LoggerContext loggerContext = this.getLoggerContext();
        this.stopAndReset(loggerContext);
        this.withLoggingSuppressed(() -> {
            LogbackConfigurator configurator = new LogbackConfigurator(loggerContext);
            this.defaultLogbackConfiguration.apply(configurator);
            loggerContext.setPackagingDataEnabled(true);
            loggerContext.start();
        });
    }

    private void withLoggingSuppressed(Runnable action) {
        TurboFilterList turboFilters = this.getLoggerContext().getTurboFilterList();
        turboFilters.add((Object)SUPPRESS_ALL_FILTER);
        try {
            action.run();
        }
        finally {
            turboFilters.remove((Object)SUPPRESS_ALL_FILTER);
        }
    }

    private void stopAndReset(LoggerContext loggerContext) {
        loggerContext.stop();
        loggerContext.reset();
    }

    private LoggerContext getLoggerContext() {
        ILoggerFactory factory = this.getLoggerFactory();
        return (LoggerContext)factory;
    }

    private ILoggerFactory getLoggerFactory() {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        while (factory instanceof SubstituteLoggerFactory) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while waiting for non-substitute logger factory", ex);
            }
            factory = LoggerFactory.getILoggerFactory();
        }
        return factory;
    }
}

