/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikerasch.logback.adapter.spring.ansi;

import io.github.mikerasch.logback.adapter.spring.ansi.AnsiColor;
import io.github.mikerasch.logback.adapter.spring.ansi.AnsiElement;
import io.github.mikerasch.logback.adapter.spring.utils.ClassUtils;
import java.io.Console;
import java.lang.reflect.Method;
import java.util.Locale;

public abstract class AnsiOutput {
    private static final String ENCODE_JOIN = ";";
    private static Enabled enabled = Enabled.DETECT;
    private static Boolean consoleAvailable;
    private static Boolean ansiCapable;
    private static final String OPERATING_SYSTEM_NAME;
    private static final String ENCODE_START = "\u001b[";
    private static final String ENCODE_END = "m";
    private static final String RESET;

    public static void configure() {
        AnsiOutput.setConsoleAvailable(true);
        AnsiOutput.setEnabled(Enabled.ALWAYS);
    }

    public static void setEnabled(Enabled enabled) {
        AnsiOutput.enabled = enabled;
    }

    public static void setConsoleAvailable(Boolean consoleAvailable) {
        AnsiOutput.consoleAvailable = consoleAvailable;
    }

    public static String toString(Object ... elements) {
        StringBuilder sb = new StringBuilder();
        if (AnsiOutput.isEnabled()) {
            AnsiOutput.buildEnabled(sb, elements);
        } else {
            AnsiOutput.buildDisabled(sb, elements);
        }
        return sb.toString();
    }

    private static void buildEnabled(StringBuilder sb, Object[] elements) {
        boolean writingAnsi = false;
        boolean containsEncoding = false;
        for (Object element : elements) {
            if (element instanceof AnsiElement) {
                containsEncoding = true;
                if (!writingAnsi) {
                    sb.append(ENCODE_START);
                    writingAnsi = true;
                } else {
                    sb.append(ENCODE_JOIN);
                }
            } else if (writingAnsi) {
                sb.append(ENCODE_END);
                writingAnsi = false;
            }
            sb.append(element);
        }
        if (containsEncoding) {
            sb.append(writingAnsi ? ENCODE_JOIN : ENCODE_START);
            sb.append(RESET);
            sb.append(ENCODE_END);
        }
    }

    private static void buildDisabled(StringBuilder sb, Object[] elements) {
        for (Object element : elements) {
            if (element instanceof AnsiElement || element == null) continue;
            sb.append(element);
        }
    }

    private static boolean isEnabled() {
        if (enabled == Enabled.DETECT) {
            if (ansiCapable == null) {
                ansiCapable = AnsiOutput.detectIfAnsiCapable();
            }
            return ansiCapable;
        }
        return enabled == Enabled.ALWAYS;
    }

    private static boolean detectIfAnsiCapable() {
        try {
            if (Boolean.FALSE.equals(consoleAvailable)) {
                return false;
            }
            if (consoleAvailable == null) {
                Boolean isTerminal;
                Console console = System.console();
                if (console == null) {
                    return false;
                }
                Method isTerminalMethod = ClassUtils.getMethodIfAvailable(Console.class, "isTerminal", new Class[0]);
                if (isTerminalMethod != null && Boolean.FALSE.equals(isTerminal = (Boolean)isTerminalMethod.invoke((Object)console, new Object[0]))) {
                    return false;
                }
            }
            return !OPERATING_SYSTEM_NAME.contains("win");
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static {
        OPERATING_SYSTEM_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        RESET = "0;" + String.valueOf(AnsiColor.DEFAULT);
    }

    public static enum Enabled {
        DETECT,
        ALWAYS,
        NEVER;

    }
}

