/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikerasch.logback.adapter.spring.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import io.github.mikerasch.logback.adapter.spring.ansi.AnsiColor;
import io.github.mikerasch.logback.adapter.spring.ansi.AnsiElement;
import io.github.mikerasch.logback.adapter.spring.ansi.AnsiStyle;
import io.github.mikerasch.logback.adapter.spring.config.LogbackConfigurator;
import io.github.mikerasch.logback.adapter.spring.rules.ColorConverter;
import io.github.mikerasch.logback.adapter.spring.rules.EnclosedInSquareBracketsConverter;
import io.github.mikerasch.logback.adapter.spring.rules.ExtendedWhitespaceThrowableProxyConverter;
import io.github.mikerasch.logback.adapter.spring.rules.WhitespaceThrowableProxyConverter;
import java.io.Console;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class DefaultLogbackConfiguration {
    private static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    private static final String NAME_AND_GROUP = "%esb(){APPLICATION_NAME}%esb{APPLICATION_GROUP}";
    private static final String DATETIME = "%d{${LOG_DATEFORMAT_PATTERN:-yyyy-MM-dd'T'HH:mm:ss.SSSXXX}}";
    private static final String DEFAULT_CONSOLE_LOG_PATTERN = DefaultLogbackConfiguration.faint("%d{${LOG_DATEFORMAT_PATTERN:-yyyy-MM-dd'T'HH:mm:ss.SSSXXX}}") + " " + DefaultLogbackConfiguration.colorByLevel("${LOG_LEVEL_PATTERN:-%5p}") + " " + DefaultLogbackConfiguration.magenta("${PID:-}") + " " + DefaultLogbackConfiguration.faint("--- %esb(){APPLICATION_NAME}%esb{APPLICATION_GROUP}[%15.15t] ${LOG_CORRELATION_PATTERN:-}") + DefaultLogbackConfiguration.cyan("%-40.40logger{39}") + " " + DefaultLogbackConfiguration.faint(":") + " %m%n${LOG_EXCEPTION_CONVERSION_WORD:-%wEx}}";
    static final String CONSOLE_LOG_PATTERN = "${CONSOLE_LOG_PATTERN:-" + DEFAULT_CONSOLE_LOG_PATTERN;

    public void apply(LogbackConfigurator config) {
        config.getConfigurationLock().lock();
        try {
            this.defaults(config);
            Appender<ILoggingEvent> consoleAppender = this.consoleAppender(config);
            config.root(Level.INFO, consoleAppender);
        }
        finally {
            config.getConfigurationLock().unlock();
        }
    }

    private void defaults(LogbackConfigurator config) {
        config.conversionRule("clr", ColorConverter.class, ColorConverter::new);
        config.conversionRule("esb", EnclosedInSquareBracketsConverter.class, EnclosedInSquareBracketsConverter::new);
        config.conversionRule("wex", WhitespaceThrowableProxyConverter.class, WhitespaceThrowableProxyConverter::new);
        config.conversionRule("wEx", ExtendedWhitespaceThrowableProxyConverter.class, ExtendedWhitespaceThrowableProxyConverter::new);
        this.putProperty(config, "CONSOLE_LOG_PATTERN", CONSOLE_LOG_PATTERN);
        this.putProperty(config, "CONSOLE_LOG_CHARSET", "${CONSOLE_LOG_CHARSET:-" + this.getConsoleCharset() + "}");
        this.putProperty(config, "CONSOLE_LOG_THRESHOLD", "${CONSOLE_LOG_THRESHOLD:-TRACE}");
        this.putProperty(config, "CONSOLE_LOG_STRUCTURED_FORMAT", "${CONSOLE_LOG_STRUCTURED_FORMAT:-}");
    }

    private String getConsoleCharset() {
        Console console = this.getConsole();
        return console != null ? console.charset().name() : DEFAULT_CHARSET;
    }

    Console getConsole() {
        return System.console();
    }

    void putProperty(LogbackConfigurator config, String name, String val) {
        config.getContext().putProperty(name, this.resolve(config, val));
    }

    private String resolve(LogbackConfigurator config, String val) {
        try {
            return OptionHelper.substVars((String)val, (PropertyContainer)config.getContext());
        }
        catch (ScanException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String faint(String value) {
        return DefaultLogbackConfiguration.color(value, AnsiStyle.FAINT);
    }

    private static String cyan(String value) {
        return DefaultLogbackConfiguration.color(value, AnsiColor.CYAN);
    }

    private static String magenta(String value) {
        return DefaultLogbackConfiguration.color(value, AnsiColor.MAGENTA);
    }

    private static String colorByLevel(String value) {
        return "%clr(" + value + "){}";
    }

    private static String color(String value, AnsiElement ansiElement) {
        return "%clr(" + value + "){" + ColorConverter.getName(ansiElement) + "}";
    }

    private Appender<ILoggingEvent> consoleAppender(LogbackConfigurator config) {
        ConsoleAppender appender = new ConsoleAppender();
        this.createAppender(config, (OutputStreamAppender<ILoggingEvent>)appender, "CONSOLE");
        config.appender("CONSOLE", (Appender<?>)appender);
        return appender;
    }

    private void createAppender(LogbackConfigurator config, OutputStreamAppender<ILoggingEvent> appender, String type) {
        appender.addFilter((Filter)this.createThresholdFilter(config, type));
        Encoder<ILoggingEvent> encoder = this.createEncoder(config, type);
        appender.setEncoder(encoder);
        config.start((LifeCycle)encoder);
    }

    private ThresholdFilter createThresholdFilter(LogbackConfigurator config, String type) {
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(this.resolve(config, "${" + type + "_LOG_THRESHOLD}"));
        filter.start();
        return filter;
    }

    private Encoder<ILoggingEvent> createEncoder(LogbackConfigurator config, String type) {
        Charset charset = this.resolveCharset(config, "${" + type + "_LOG_CHARSET}");
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setCharset(charset);
        encoder.setPattern(this.resolve(config, "${" + type + "_LOG_PATTERN}"));
        return encoder;
    }

    private Charset resolveCharset(LogbackConfigurator config, String val) {
        return Charset.forName(this.resolve(config, val));
    }
}

