/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikerasch.logback.adapter.spring.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class LogbackConfigurator {
    private final LoggerContext context;

    public LogbackConfigurator(LoggerContext context) {
        this.context = context;
    }

    public LoggerContext getContext() {
        return this.context;
    }

    public ReentrantLock getConfigurationLock() {
        return this.context.getConfigurationLock();
    }

    public <T extends Converter<?>> void conversionRule(String conversionWord, Class<T> converterClass, Supplier<T> converterSupplier) {
        HashMap<String, Supplier<T>> registry = (HashMap<String, Supplier<T>>)this.context.getObject("PATTERN_RULE_REGISTRY_FOR_SUPPLIERS");
        if (registry == null) {
            registry = new HashMap<String, Supplier<T>>();
            this.context.putObject("PATTERN_RULE_REGISTRY_FOR_SUPPLIERS", registry);
        }
        registry.put(conversionWord, converterSupplier);
    }

    public void appender(String name, Appender<?> appender) {
        appender.setName(name);
        this.start((LifeCycle)appender);
    }

    public void logger(String name, Level level) {
        this.logger(name, level, true);
    }

    public void logger(String name, Level level, boolean additive) {
        this.logger(name, level, additive, null);
    }

    public void logger(String name, Level level, boolean additive, Appender<ILoggingEvent> appender) {
        Logger logger = this.context.getLogger(name);
        if (level != null) {
            logger.setLevel(level);
        }
        logger.setAdditive(additive);
        if (appender != null) {
            logger.addAppender(appender);
        }
    }

    @SafeVarargs
    public final void root(Level level, Appender<ILoggingEvent> ... appenders) {
        Logger logger = this.context.getLogger("ROOT");
        if (level != null) {
            logger.setLevel(level);
        }
        for (Appender<ILoggingEvent> appender : appenders) {
            logger.addAppender(appender);
        }
    }

    public void start(LifeCycle lifeCycle) {
        if (lifeCycle instanceof ContextAware) {
            ContextAware contextAware = (ContextAware)lifeCycle;
            contextAware.setContext((Context)this.context);
        }
        lifeCycle.start();
    }
}

