/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikerasch.logback.adapter.spring.rules;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.CompositeConverter;
import io.github.mikerasch.logback.adapter.spring.utils.StringUtils;

public class EnclosedInSquareBracketsConverter
extends CompositeConverter<ILoggingEvent> {
    protected String transform(ILoggingEvent event, String in) {
        in = !StringUtils.hasLength(in) ? this.resolveFromFirstOption(event) : in;
        return !StringUtils.hasLength(in) ? "" : "[%s] ".formatted(in);
    }

    private String resolveFromFirstOption(ILoggingEvent event) {
        String name = this.getFirstOption();
        if (name == null) {
            return null;
        }
        String value = (String)event.getLoggerContextVO().getPropertyMap().get(name);
        return value != null ? value : System.getProperty(name);
    }
}

