/*
 * Decompiled with CFR 0.152.
 */
package io.github.mitsumi.solutions.shared.utils;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;

public final class DateTimeUtils {
    public static final ZoneId ZONE_ID_UTC = ZoneId.of("UTC");
    public static final ZoneId ZONE_ID_JST = ZoneId.of("Asia/Tokyo");

    public static LocalDateTime getUtcTime() {
        return LocalDateTime.now(ZONE_ID_UTC);
    }

    public static LocalDateTime getJstTime() {
        return LocalDateTime.now(ZONE_ID_JST);
    }

    public static ZonedDateTime getUtcZonedDateTime() {
        return DateTimeUtils.getUtcTime().atZone(ZONE_ID_UTC);
    }

    public static OffsetDateTime getOffsetDateTime() {
        return OffsetDateTime.now();
    }

    public static long getUtcEpochSecond() {
        return DateTimeUtils.getUtcZonedDateTime().toEpochSecond();
    }

    public static boolean isSame(LocalDateTime t1, LocalDateTime t2) {
        return t1.equals(t2);
    }

    public static boolean isSame(OffsetDateTime t1, LocalDateTime t2) {
        return DateTimeUtils.isSame(t1.toLocalDateTime(), t2);
    }

    public static boolean isSameMs(LocalDateTime t1, LocalDateTime t2) {
        ChronoUnit compareUnit = ChronoUnit.MILLIS;
        return t1.truncatedTo(compareUnit).equals(t2.truncatedTo(compareUnit));
    }

    public static boolean isBetween(LocalDateTime target, LocalDateTime from, LocalDateTime to) {
        return !target.isAfter(to) && !target.isBefore(from);
    }

    public static boolean isBetween(OffsetDateTime target, LocalDateTime from, LocalDateTime to) {
        return DateTimeUtils.isBetween(target.toLocalDateTime(), from, to);
    }

    public static OffsetDateTime getOffsetDateTimeUtc(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, 0, ZoneOffset.systemDefault().getRules().getOffset(LocalDateTime.now())).withOffsetSameInstant(ZoneOffset.UTC);
    }

    public static OffsetDateTime getUtcOffsetDateTimeFromJst(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        LocalDateTime jstLocalDateTime = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second);
        ZonedDateTime jstZonedDateTime = jstLocalDateTime.atZone(ZONE_ID_JST);
        ZonedDateTime utcZonedDateTime = jstZonedDateTime.withZoneSameInstant(ZONE_ID_UTC);
        return utcZonedDateTime.toOffsetDateTime();
    }

    public static OffsetDateTime toOffsetDateTime(LocalDateTime localDateTime) {
        return DateTimeUtils.toOffsetDateTime(localDateTime, ZoneOffset.UTC);
    }

    public static OffsetDateTime toOffsetDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        if (localDateTime == null) {
            return null;
        }
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }

    public static OffsetDateTime toJSTOffsetDateTime(LocalDateTime jstLocalDateTime) {
        ZonedDateTime localZonedDateTime = jstLocalDateTime.atZone(ZONE_ID_JST);
        return OffsetDateTime.ofInstant(localZonedDateTime.toInstant(), ZONE_ID_JST);
    }

    public static OffsetDateTime toJSTOffsetDateTime(OffsetDateTime utcOffsetDateTime) {
        ZonedDateTime zonedDateTime = utcOffsetDateTime.toZonedDateTime();
        ZonedDateTime jstZonedDateTime = zonedDateTime.withZoneSameInstant(ZONE_ID_JST);
        return OffsetDateTime.ofInstant(jstZonedDateTime.toInstant(), ZONE_ID_JST);
    }

    public static OffsetDateTime toJSTOffsetDateTimeWithUtc(LocalDateTime utcLocalDateTime) {
        ZonedDateTime utcZonedDateTime = utcLocalDateTime.atZone(ZONE_ID_UTC);
        ZonedDateTime jstZonedDateTime = utcZonedDateTime.withZoneSameInstant(ZONE_ID_JST);
        return jstZonedDateTime.toOffsetDateTime();
    }

    public static LocalDateTime toUtcLocalDateTime(LocalDateTime jstLocalDateTime) {
        ZonedDateTime jstZonedDateTime = jstLocalDateTime.atZone(ZONE_ID_JST);
        ZonedDateTime utcZonedDateTime = jstZonedDateTime.withZoneSameInstant(ZONE_ID_UTC);
        return utcZonedDateTime.toLocalDateTime();
    }

    public static Date getDateSystemDefaultZone(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return Date.from(ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, 0, ZoneId.systemDefault()).toInstant());
    }

    public static OffsetDateTime toOffsetDateTimeUtc(Date date) {
        return date.toInstant().atOffset(ZoneOffset.UTC);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneOffset.UTC);
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        if (Objects.isNull(localDate)) {
            return null;
        }
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(OffsetDateTime offsetDateTime) {
        if (Objects.isNull(offsetDateTime)) {
            return null;
        }
        return Date.from(offsetDateTime.toInstant());
    }

    public static LocalDateTime toLocalDateTime(String dateTimeString) {
        return LocalDateTime.parse(dateTimeString, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static LocalDateTime toUtcLocalDateTime(String jstOffsetDateTimeString) {
        OffsetDateTime jstOffsetDateTime = OffsetDateTime.parse(jstOffsetDateTimeString);
        return DateTimeUtils.toUtcLocalDateTime(jstOffsetDateTime);
    }

    public static LocalDateTime toUtcLocalDateTime(OffsetDateTime jstOffsetDateTime) {
        return ZonedDateTime.ofInstant(jstOffsetDateTime.toInstant(), ZONE_ID_UTC).toLocalDateTime();
    }

    public static LocalDateTime toSystemZoneLocalDateTime(OffsetDateTime offsetDateTime) {
        if (Objects.isNull(offsetDateTime)) {
            throw new IllegalArgumentException("OffsetDateTime cannot be null");
        }
        return offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static boolean isBefore(Date time1, LocalDateTime time2) {
        return time1.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().isBefore(time2);
    }

    public static boolean isValidDate(int year, int month, int dayOfMonth) {
        try {
            LocalDate date = LocalDate.of(year, month, dayOfMonth);
            return year == date.getYear() && month == date.getMonthValue() && dayOfMonth == date.getDayOfMonth();
        }
        catch (DateTimeException e) {
            return false;
        }
    }

    public static OffsetDateTime dateStringToOffsetDateTimeAtStartOfDay(String dateTimeString, DateTimeFormatter dateTimeFormatter, ZoneId zoneId) {
        return LocalDate.parse(dateTimeString, dateTimeFormatter).atStartOfDay(zoneId).toOffsetDateTime();
    }

    public static OffsetDateTime dateStringToOffsetDateTimeAtEndOfDay(String dateTimeString, DateTimeFormatter dateTimeFormatter, ZoneId zoneId) {
        return LocalDate.parse(dateTimeString, dateTimeFormatter).atTime(LocalTime.MAX).atZone(zoneId).toOffsetDateTime();
    }

    @Generated
    private DateTimeUtils() {
    }
}

