/*
 * Decompiled with CFR 0.152.
 */
package com.monmonkeygroup.openapi.client;

import com.monmonkeygroup.openapi.OpenApiException;
import com.monmonkeygroup.openapi.client.IClientConn;
import com.monmonkeygroup.openapi.client.ISocketServiceListener;
import com.monmonkeygroup.openapi.protocol.IProtocol;
import com.monmonkeygroup.openapi.protocol.Packet;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketConn
extends WebSocketClient
implements IClientConn {
    private static final Logger log = LoggerFactory.getLogger(WebsocketConn.class);
    private Set<ISocketServiceListener> listeners = ConcurrentHashMap.newKeySet();
    private final IProtocol<String> protocol;

    public WebsocketConn(URI uri, IProtocol<String> protocol) {
        super(uri);
        this.protocol = protocol;
    }

    @Override
    public void init() throws OpenApiException {
        try {
            if (!this.connectBlocking(15L, TimeUnit.SECONDS)) {
                throw new OpenApiException(0, "connect timeout");
            }
        }
        catch (InterruptedException e) {
            throw new OpenApiException(0, e.getMessage());
        }
    }

    @Override
    public boolean isOpen() {
        return super.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPacket(Packet packet) {
        String s = this.protocol.pack(packet);
        log.debug("WriteMessage: {}", (Object)s);
        WebsocketConn websocketConn = this;
        synchronized (websocketConn) {
            this.send(s);
        }
    }

    @Override
    public boolean reconnectSocket() throws Exception {
        this.reconnect();
        return true;
    }

    @Override
    public void close(String reason) {
        this.close(1000, reason);
    }

    public void onOpen(ServerHandshake serverHandshake) {
        for (ISocketServiceListener listener : this.listeners) {
            listener.onConnected();
        }
    }

    public void onMessage(String s) {
        Packet packet;
        log.debug("ReadMessage: {}", (Object)s);
        try {
            packet = this.protocol.unpack(s);
            if (null == packet) {
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (ISocketServiceListener listener : this.listeners) {
            listener.onMessage(packet);
        }
    }

    public void onClose(int i, String s, boolean b) {
        log.debug("close conn, err: {},{}", (Object)i, (Object)s);
        for (ISocketServiceListener listener : this.listeners) {
            if (b) {
                listener.onClose("close by client, " + s);
                continue;
            }
            listener.onClose("close conn, " + s);
        }
    }

    public void onError(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
    }

    @Override
    public void addListener(ISocketServiceListener listener) {
        this.listeners.add(listener);
    }
}

