package com.monmonkeygroup.openapi;

public class Config {
    private static String defaultQuoteUrl = "wss://www.mmkpp.com:56011";
    private static String defaultTradeUrl = "wss://www.mmkpp.com:56010";
    private static String defaultSimulatedQuoteUrl = "wss://www.mmktt.com:56011";
    private static String defaultSimulatedTradeUrl = "wss://www.mmktt.com:56010";
    private String user;
    private String quoteAccessToken;
    private String tradeAccessToken;
    private boolean useSimulateEnv;
    private String tradeUrl;
    private String quoteUrl;

    private Config() {
    }

    public String getUser() {
        return user;
    }

    public String getQuoteAccessToken() {
        return quoteAccessToken;
    }

    public String getTradeAccessToken() {
        return tradeAccessToken;
    }

    public boolean getUseSimulateEnv() {
        return useSimulateEnv;
    }

    public String getTradeUrl() {
        return tradeUrl;
    }

    public String getQuoteUrl() {
        return quoteUrl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFormEnv() {
        Builder builder = new Builder();
        builder.setUser(System.getenv("MMK_USER"));
        builder.setQuoteAccessToken(System.getenv("MMK_QUOTE_ACCESS_TOKEN"));
        builder.setTradeAccessToken(System.getenv("MMK_TRADE_ACCESS_TOKEN"));
        builder.setUseSimulateEnv(Boolean.parseBoolean(System.getenv("MMK_USE_SIMULATE_ENV")));
        builder.setQuoteUrl(System.getenv("MMK_QUOTE_URL"));
        builder.setTradeUrl(System.getenv("MMK_TRADE_URL"));

        return builder;
    }

    public static final class Builder {
        private String user_;
        private String quoteAccessToken_;
        private String tradeAccessToken_;
        private boolean useSimulateEnv_;
        private String tradeUrl_;
        private String quoteUrl_;

        private Builder() {
        }

        public Config build() {
            if (null == user_ || user_.isEmpty()) {
                throw new RuntimeException("don't has user. please set user");
            }

            if (null == quoteUrl_ || quoteUrl_.isEmpty()) {
                quoteUrl_ = useSimulateEnv_ ? defaultSimulatedQuoteUrl : defaultQuoteUrl;
            }

            if (null == tradeUrl_ || tradeUrl_.isEmpty()) {
                tradeUrl_ = useSimulateEnv_ ? defaultSimulatedTradeUrl : defaultTradeUrl;
            }

            Config config = new Config();
            config.user = user_;
            config.quoteAccessToken = quoteAccessToken_;
            config.tradeAccessToken = tradeAccessToken_;
            config.useSimulateEnv = useSimulateEnv_;
            config.quoteUrl = quoteUrl_;
            config.tradeUrl = tradeUrl_;

            return config;
        }

        public String getUser() {
            return user_;
        }

        public Builder setUser(String user) {
            if (null != user) {
                this.user_ = user;
            }

            return this;
        }

        public String getQuoteAccessToken_() {
            return quoteAccessToken_;
        }

        public Builder setQuoteAccessToken(String quoteAccessToken) {
            if (null != quoteAccessToken) {
                this.quoteAccessToken_ = quoteAccessToken;
            }

            return this;
        }

        public String getTradeAccessToken() {
            return tradeAccessToken_;
        }

        public Builder setTradeAccessToken(String tradeAccessToken) {
            if (null != tradeAccessToken) {
                this.tradeAccessToken_ = tradeAccessToken;
            }

            return this;
        }

        public boolean getUseSimulateEnv() {
            return useSimulateEnv_;
        }

        public Builder setUseSimulateEnv(boolean useSimulateEnv) {
            this.useSimulateEnv_ = useSimulateEnv;
            return this;
        }

        public String getTradeUrl() {
            return tradeUrl_;
        }

        public Builder setTradeUrl(String tradeUrl) {
            if (null != tradeUrl) {
                this.tradeUrl_ = tradeUrl;
            }

            return this;
        }

        public String getQuoteUrl() {
            return quoteUrl_;
        }

        public Builder setQuoteUrl(String quoteUrl) {
            if (null != quoteUrl) {
                this.quoteUrl_ = quoteUrl;
            }

            return this;
        }
    }
}
