package com.monmonkeygroup.openapi.trade;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CreateOrderRequest {
    private String tradeAccountId;
    private OrderSide orderSide;
    private OrderType orderType;
    private String symbol;
    private Double price;
    private double qty;
    private TimeInForce tif;
    private Double expiryDate;
    private String clientTxId;

    public CreateOrderRequest(String tradeAccountId,
                              OrderSide orderSide,
                              OrderType orderType,
                              String symbol,
                              double qty) {
        this.tradeAccountId = tradeAccountId;
        this.orderSide = orderSide;
        this.orderType = orderType;
        this.symbol = symbol;
        this.qty = qty;
    }

    public String getTradeAccountId() {
        return tradeAccountId;
    }

    public CreateOrderRequest setTradeAccountId(String tradeAccountId) {
        this.tradeAccountId = tradeAccountId;
        return this;
    }

    public String getClientTxId() {
        return clientTxId;
    }

    public CreateOrderRequest setClientTxId(String clientTxId) {
        this.clientTxId = clientTxId;
        return this;
    }

    public String getSymbol() {
        return symbol;
    }

    public CreateOrderRequest setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public Double getPrice() {
        return price;
    }

    public CreateOrderRequest setPrice(Double price) {
        this.price = price;
        return this;
    }

    public Double getQty() {
        return qty;
    }

    public CreateOrderRequest setQty(double qty) {
        this.qty = qty;
        return this;
    }

    public OrderType getOrderType() {
        return orderType;
    }

    public CreateOrderRequest setOrderType(OrderType orderType) {
        this.orderType = orderType;
        return this;
    }

    public OrderSide getOrderSide() {
        return orderSide;
    }

    public CreateOrderRequest setOrderSide(OrderSide orderSide) {
        this.orderSide = orderSide;
        return this;
    }

    public TimeInForce getTif() {
        return tif;
    }

    public CreateOrderRequest setTif(TimeInForce tif) {
        this.tif = tif;
        return this;
    }

    public Double getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(Double expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
