/*
 * Decompiled with CFR 0.152.
 */
package com.monmonkeygroup.openapi.protocol.v1;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.monmonkeygroup.openapi.protocol.IProtocol;
import com.monmonkeygroup.openapi.protocol.Packet;
import com.monmonkeygroup.openapi.protocol.v1.GsonUtil;
import java.util.Objects;

public class ProtocolV1
implements IProtocol<String> {
    private static final String FIELD_ACTION_TYPE = "actionType";
    private static final String FIELD_ACTION_NAME = "actionName";
    private static final String FIELD_TX_ID = "txId";
    private static final String FIELD_IS_SUB = "isSub";
    private static final String FIELD_ERR_CODE = "errCode";
    private static final String FIELD_REQUEST_BODY = "requestBody";
    private static final String FIELD_REPLY_BODY = "replyBody";
    private static final String FIELD_PUSH_BODY = "objectBody";
    private final Gson gson = new Gson();

    @Override
    public Packet unpack(String data) {
        JsonObject obj = JsonParser.parseString((String)data).getAsJsonObject();
        String actionType = GsonUtil.getAsString(obj, FIELD_ACTION_TYPE);
        if (null == actionType || actionType.equals("")) {
            return null;
        }
        if (Objects.equals(actionType, "systemState")) {
            return null;
        }
        if (Objects.equals(actionType, "systemError")) {
            Packet packet = new Packet();
            packet.setActionType(actionType);
            packet.setErrCode(GsonUtil.getAsInt(obj, FIELD_ERR_CODE));
            return packet;
        }
        String actionName = GsonUtil.getAsString(obj, FIELD_ACTION_NAME);
        if (null == actionName) {
            return null;
        }
        Packet packet = new Packet();
        packet.setActionType(actionType);
        packet.setActionName(actionName);
        switch (actionType) {
            case "reply": {
                packet.setBody(GsonUtil.getJsonObjectAsString(obj, FIELD_REPLY_BODY));
                packet.setErrCode(GsonUtil.getAsInt(obj, FIELD_ERR_CODE));
                packet.setTxId(GsonUtil.getAsInt(obj, FIELD_TX_ID));
                break;
            }
            case "update": {
                packet.setBody(GsonUtil.getJsonObjectAsString(obj, FIELD_PUSH_BODY));
                break;
            }
            default: {
                return null;
            }
        }
        return packet;
    }

    @Override
    public String pack(Packet packet) {
        JsonObject result = new JsonObject();
        GsonUtil.addString(result, FIELD_ACTION_TYPE, packet.getActionType());
        GsonUtil.addString(result, FIELD_ACTION_NAME, packet.getActionName());
        GsonUtil.addLong(result, FIELD_TX_ID, packet.getTxId());
        if (Objects.equals(packet.getActionType(), "subscribe")) {
            GsonUtil.addBoolean(result, FIELD_IS_SUB, packet.isSub());
        } else if (Objects.equals(packet.getActionType(), "request") && null != packet.getBody()) {
            result.add(FIELD_REQUEST_BODY, JsonParser.parseString((String)packet.getBody()));
        }
        return this.gson.toJson((JsonElement)result);
    }

    @Override
    public int version() {
        return 1;
    }
}

