/*
 * Decompiled with CFR 0.152.
 */
package io.github.mwttg.wavefront.extractor;

import io.github.mwttg.wavefront.extractor.FaceExtractor;
import io.github.mwttg.wavefront.extractor.FileData;
import io.github.mwttg.wavefront.extractor.Triangle;
import io.github.mwttg.wavefront.extractor.Vector2Extractor;
import io.github.mwttg.wavefront.extractor.Vector3Extractor;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector3f;

public final class ExtractorService {
    private static final String SPACE = " ";

    private ExtractorService() {
    }

    public static FileData extractFrom(List<String> lines) {
        ArrayList<Vector3f> vertices = new ArrayList<Vector3f>();
        ArrayList<Vector2f> textureCoords = new ArrayList<Vector2f>();
        ArrayList<Vector3f> normals = new ArrayList<Vector3f>();
        ArrayList<Triangle> faces = new ArrayList<Triangle>();
        for (String line : lines) {
            if (line.isBlank()) continue;
            String[] parts = line.split(SPACE);
            switch (parts[0]) {
                case "v": {
                    Vector3f vertex = Vector3Extractor.from(parts);
                    vertices.add(vertex);
                    break;
                }
                case "vn": {
                    Vector3f normal = Vector3Extractor.from(parts);
                    normals.add(normal);
                    break;
                }
                case "vt": {
                    Vector2f uv = Vector2Extractor.from(parts);
                    textureCoords.add(uv);
                    break;
                }
                case "f": {
                    Triangle face = FaceExtractor.from(parts);
                    faces.add(face);
                    break;
                }
            }
        }
        return new FileData(vertices, textureCoords, normals, faces);
    }
}

