/*
 * Decompiled with CFR 0.152.
 */
package io.github.mwttg.wavefront.extractor;

import io.github.mwttg.wavefront.extractor.Index;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class IndexExtractor {
    private static final String SEPARATOR = "/";

    private IndexExtractor() {
    }

    static Index from(String definition) {
        Type type = Type.getTypeFrom(definition);
        String[] parts = definition.split(SEPARATOR);
        switch (type) {
            case TYPE1: {
                int vertexIndex = Integer.parseInt(parts[0]) - 1;
                return new Index(vertexIndex, null, null);
            }
            case TYPE2: {
                int vertexIndex = Integer.parseInt(parts[0]) - 1;
                int uvIndex = Integer.parseInt(parts[1]) - 1;
                return new Index(vertexIndex, uvIndex, null);
            }
            case TYPE3: {
                int vertexIndex = Integer.parseInt(parts[0]) - 1;
                int normalIndex = Integer.parseInt(parts[2]) - 1;
                return new Index(vertexIndex, null, normalIndex);
            }
            case TYPE4: {
                int vertexIndex = Integer.parseInt(parts[0]) - 1;
                int uvIndex = Integer.parseInt(parts[1]) - 1;
                int normalIndex = Integer.parseInt(parts[2]) - 1;
                return new Index(vertexIndex, uvIndex, normalIndex);
            }
        }
        throw new RuntimeException("No TYPE for face definition '%s' found.".formatted(definition));
    }

    static enum Type {
        TYPE1,
        TYPE2,
        TYPE3,
        TYPE4;

        private static final Pattern TYPE1_PATTERN;
        private static final Pattern TYPE2_PATTERN;
        private static final Pattern TYPE3_PATTERN;
        private static final Pattern TYPE4_PATTERN;

        static Type getTypeFrom(String definition) {
            Matcher matcherType4 = TYPE4_PATTERN.matcher(definition);
            if (matcherType4.matches()) {
                return TYPE4;
            }
            Matcher matcherType1 = TYPE1_PATTERN.matcher(definition);
            if (matcherType1.matches()) {
                return TYPE1;
            }
            Matcher matcherType2 = TYPE2_PATTERN.matcher(definition);
            if (matcherType2.matches()) {
                return TYPE2;
            }
            Matcher matcherType3 = TYPE3_PATTERN.matcher(definition);
            if (matcherType3.matches()) {
                return TYPE3;
            }
            throw new IllegalArgumentException("No matching tpe found for definition '%s'.".formatted(definition));
        }

        static {
            TYPE1_PATTERN = Pattern.compile("^[0-9]+$");
            TYPE2_PATTERN = Pattern.compile("^[0-9]+/[0-9]+$");
            TYPE3_PATTERN = Pattern.compile("^[0-9]+//[0-9]+$");
            TYPE4_PATTERN = Pattern.compile("^[0-9]+/[0-9]+/[0-9]+$");
        }
    }
}

