/*
 * Decompiled with CFR 0.152.
 */
package io.github.mwttg.wavefront.transformer;

import io.github.mwttg.wavefront.extractor.FileData;
import io.github.mwttg.wavefront.extractor.Index;
import io.github.mwttg.wavefront.extractor.Triangle;
import io.github.mwttg.wavefront.transformer.Wavefront;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector3f;

public final class TransformerService {
    private TransformerService() {
    }

    public static Wavefront transform(FileData data) {
        List<Vector3f> originalVertices = data.vertices();
        List<Vector2f> originalTextureCoordinates = data.textureCoordinates();
        List<Vector3f> originalNormals = data.normals();
        List<Triangle> originalFaces = data.faces();
        float[] resultVertices = new float[originalFaces.size() * 3 * 3];
        float[] resultTextureCoordinates = null;
        float[] resultNormals = null;
        for (int index = 0; index < originalFaces.size(); ++index) {
            Triangle triangle = originalFaces.get(index);
            Index point1 = triangle.point1();
            Index point2 = triangle.point2();
            Index point3 = triangle.point3();
            int vertexIndexPoint1 = point1.vertex();
            Vector3f vertex1 = originalVertices.get(vertexIndexPoint1);
            resultVertices[index * 9] = vertex1.x();
            resultVertices[index * 9 + 1] = vertex1.y();
            resultVertices[index * 9 + 2] = vertex1.z();
            int vertexIndexPoint2 = point2.vertex();
            Vector3f vertex2 = originalVertices.get(vertexIndexPoint2);
            resultVertices[index * 9 + 3] = vertex2.x();
            resultVertices[index * 9 + 4] = vertex2.y();
            resultVertices[index * 9 + 5] = vertex2.z();
            int vertexIndexPoint3 = point3.vertex();
            Vector3f vertex3 = originalVertices.get(vertexIndexPoint3);
            resultVertices[index * 9 + 6] = vertex3.x();
            resultVertices[index * 9 + 7] = vertex3.y();
            resultVertices[index * 9 + 8] = vertex3.z();
            if (point1.textureCoordinate() != null) {
                if (resultTextureCoordinates == null) {
                    resultTextureCoordinates = new float[originalFaces.size() * 3 * 2];
                }
                Integer uvIndexPoint1 = point1.textureCoordinate();
                Vector2f uv1 = originalTextureCoordinates.get(uvIndexPoint1);
                resultTextureCoordinates[index * 6] = uv1.x();
                resultTextureCoordinates[index * 6 + 1] = uv1.y();
                Integer uvIndexPoint2 = point2.textureCoordinate();
                Vector2f uv2 = originalTextureCoordinates.get(uvIndexPoint2);
                resultTextureCoordinates[index * 6 + 2] = uv2.x();
                resultTextureCoordinates[index * 6 + 3] = uv2.y();
                Integer uvIndexPoint3 = point3.textureCoordinate();
                Vector2f uv3 = originalTextureCoordinates.get(uvIndexPoint3);
                resultTextureCoordinates[index * 6 + 4] = uv3.x();
                resultTextureCoordinates[index * 6 + 5] = uv3.y();
            }
            if (point1.normal() == null) continue;
            if (resultNormals == null) {
                resultNormals = new float[originalFaces.size() * 3 * 3];
            }
            Integer normalIndexPoint1 = point1.normal();
            Vector3f normal1 = originalNormals.get(normalIndexPoint1);
            resultNormals[index * 9] = normal1.x();
            resultNormals[index * 9 + 1] = normal1.y();
            resultNormals[index * 9 + 2] = normal1.z();
            Integer normalIndexPoint2 = point2.normal();
            Vector3f normal2 = originalNormals.get(normalIndexPoint2);
            resultNormals[index * 9 + 3] = normal2.x();
            resultNormals[index * 9 + 4] = normal2.y();
            resultNormals[index * 9 + 5] = normal2.z();
            Integer normalIndexPoint3 = point3.normal();
            Vector3f normal3 = originalNormals.get(normalIndexPoint3);
            resultNormals[index * 9 + 6] = normal3.x();
            resultNormals[index * 9 + 7] = normal3.y();
            resultNormals[index * 9 + 8] = normal3.z();
        }
        return new Wavefront(resultVertices, resultTextureCoordinates, resultNormals);
    }
}

