/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ksoot.problem.core.ThrowableProblem;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public final class ApplicationProblem
extends ThrowableProblem {
    private final HttpStatus status;
    private final String code;
    private final String title;
    private final String detail;
    private Map<String, Object> parameters;

    public ApplicationProblem(HttpStatus status, String code, String title, String detail, @Nullable ThrowableProblem cause, @Nullable Map<String, Object> parameters) {
        super(cause);
        Assert.notNull((Object)status, (String)"'status' must not be null");
        Assert.hasText((String)code, (String)"'code' must not be null or empty");
        Assert.hasText((String)title, (String)"'title' must not be null or empty");
        Assert.hasText((String)detail, (String)"'detail' must not be null or empty");
        this.status = status;
        this.code = code;
        this.title = title;
        this.detail = detail;
        this.parameters = parameters;
    }

    public static ApplicationProblem of(HttpStatus status, String code, String title, String detail) {
        return new ApplicationProblem(status, code, title, detail, null, null);
    }

    public static ApplicationProblem of(HttpStatus status, String code, String title, String detail, @Nullable ThrowableProblem cause) {
        return new ApplicationProblem(status, code, title, detail, cause, null);
    }

    public static ApplicationProblem of(HttpStatus status, String code, String title, String detail, @Nullable Map<String, Object> parameters) {
        return new ApplicationProblem(status, code, title, detail, null, parameters);
    }

    public static ApplicationProblem of(HttpStatus status, String code, String title, String detail, @Nullable ThrowableProblem cause, @Nullable Map<String, Object> parameters) {
        return new ApplicationProblem(status, code, title, detail, cause, parameters);
    }

    @JsonIgnore
    public HttpStatus status() {
        return this.status;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDetail() {
        return this.detail;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

