/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.Problem;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.http.HttpStatus;

public class MultiProblem
extends RuntimeException {
    private final HttpStatus status;
    private final List<Problem> problems;

    private MultiProblem(HttpStatus status, List<Problem> problems) {
        super(status.getReasonPhrase());
        Validate.notNull((Object)status, (String)"'status' must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(problems), (String)"'problems' must not be null or empty", (Object[])new Object[0]);
        Validate.noNullElements(problems, (String)"'problems' must not contain null elements", (Object[])new Object[0]);
        this.status = status;
        this.problems = Collections.unmodifiableList(problems);
    }

    public static MultiProblem of(HttpStatus status, List<Problem> problems) {
        return new MultiProblem(status, problems);
    }

    public static MultiProblem of(List<Problem> problems) {
        return new MultiProblem(HttpStatus.MULTI_STATUS, problems);
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public List<Problem> getProblems() {
        return this.problems;
    }
}

