/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice;

import com.ksoot.problem.core.ErrorResponseBuilder;
import com.ksoot.problem.core.Problem;
import com.ksoot.problem.core.ProblemUtils;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.BaseAdviceTrait;
import com.ksoot.problem.spring.config.ProblemBeanRegistry;
import com.ksoot.problem.spring.config.ProblemMessageProvider;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;

public interface AdviceTrait<T, R>
extends BaseAdviceTrait {
    public static final Logger logger = LoggerFactory.getLogger(AdviceTrait.class);

    default public R create(Throwable throwable, T request) {
        HttpStatus status = HttpStatus.valueOf((int)ProblemUtils.resolveStatus(throwable).value());
        return this.create(throwable, request, status, this.toProblem(throwable));
    }

    default public R create(Throwable throwable, T request, HttpStatus status) {
        return this.create(throwable, request, status, new HttpHeaders());
    }

    default public R create(Throwable throwable, T request, HttpStatus status, HttpHeaders headers) {
        return this.create(throwable, request, status, headers, (Problem)this.toProblem(throwable, (T)status));
    }

    default public R create(Throwable throwable, T request, HttpStatus status, Problem problem) {
        return this.create(throwable, request, status, new HttpHeaders(), problem);
    }

    default public R create(Throwable throwable, T request, HttpStatus status, HttpHeaders headers, Problem problem) {
        this.log(throwable, status);
        return this.errorResponseBuilder().buildResponse(throwable, request, status, headers, problem);
    }

    default public R toProblem(Throwable throwable, T request) {
        return this.toProblem(throwable, request, "internal.server.error", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    default public R toProblem(Throwable throwable, T request, String defaultErrorKey, HttpStatus defaultStatus) {
        String errorKey = ClassUtils.getName((Object)throwable);
        ProblemMessageSourceResolver statusResolver = ProblemMessageSourceResolver.of("status." + errorKey, defaultStatus.value());
        HttpStatus status = defaultStatus;
        try {
            String statusCode = ProblemMessageProvider.getMessage(statusResolver);
            status = HttpStatus.valueOf((String)statusCode);
        }
        catch (Exception statusCode) {
            // empty catch block
        }
        ProblemMessageSourceResolver defaultCodeResolver = ProblemMessageSourceResolver.of("code." + defaultErrorKey, status.value());
        ProblemMessageSourceResolver defaultTitleResolver = ProblemMessageSourceResolver.of("title." + defaultErrorKey, status.getReasonPhrase());
        ProblemMessageSourceResolver defaultDetailResolver = ProblemMessageSourceResolver.of("detail." + defaultErrorKey, throwable.getMessage());
        ProblemMessageSourceResolver codeResolver = ProblemMessageSourceResolver.of("code." + errorKey, ProblemMessageProvider.getMessage(defaultCodeResolver));
        ProblemMessageSourceResolver titleResolver = ProblemMessageSourceResolver.of("title." + errorKey, ProblemMessageProvider.getMessage(defaultTitleResolver));
        ProblemMessageSourceResolver detailResolver = ProblemMessageSourceResolver.of("detail." + errorKey, ProblemMessageProvider.getMessage(defaultDetailResolver));
        ThrowableProblem problem = this.toProblem(throwable, (MessageSourceResolvable)codeResolver, (MessageSourceResolvable)titleResolver, (MessageSourceResolvable)detailResolver, statusResolver);
        return this.create(throwable, request, status, problem);
    }

    default public void log(Throwable throwable, HttpStatus status) {
        logger.error(status.getReasonPhrase(), throwable);
    }

    default public ErrorResponseBuilder<T, R> errorResponseBuilder() {
        return ProblemBeanRegistry.errorResponseBuilder();
    }
}

