/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice;

import com.ksoot.problem.core.Problem;
import com.ksoot.problem.core.ProblemUtils;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.config.ProblemBeanRegistry;
import com.ksoot.problem.spring.config.ProblemMessageProvider;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public interface BaseAdviceTrait {
    default public ThrowableProblem toProblem(Throwable throwable) {
        HttpStatus status = HttpStatus.valueOf((int)ProblemUtils.resolveStatus(throwable).value());
        return this.toProblem(throwable, status);
    }

    default public ThrowableProblem toProblem(Throwable throwable, HttpStatus status) {
        return this.toProblem(throwable, status, throwable.getMessage());
    }

    default public ThrowableProblem toProblem(Throwable throwable, HttpStatus status, String detail) {
        return this.toProblem(throwable, ProblemUtils.statusCode((HttpStatusCode)status), status.getReasonPhrase(), detail);
    }

    default public ThrowableProblem toProblem(Throwable throwable, String code, String title, String detail) {
        return this.toProblem(throwable, code, title, detail, new LinkedHashMap<String, Object>());
    }

    default public ThrowableProblem toProblem(Throwable throwable, String code, String title, String detail, Map<String, Object> parameters) {
        ThrowableProblem problem = this.prepare(throwable, code, title, detail, parameters);
        StackTraceElement[] stackTrace = ProblemUtils.createStackTrace(throwable);
        problem.setStackTrace(stackTrace);
        return problem;
    }

    default public ThrowableProblem toProblem(Throwable throwable, HttpStatus status, MessageSourceResolvable detailResolver) {
        return this.toProblem(throwable, ProblemUtils.statusCode((HttpStatusCode)status), status.getReasonPhrase(), detailResolver);
    }

    default public ThrowableProblem toProblem(Throwable throwable, String code, String title, MessageSourceResolvable detailResolver) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
            parameters.put("detailResolver", detailResolver);
        }
        return this.toProblem(throwable, code, title, ProblemMessageProvider.getMessage(detailResolver), parameters);
    }

    default public ThrowableProblem toProblem(Throwable throwable, String code, MessageSourceResolvable titleResolver, MessageSourceResolvable detailResolver) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
            parameters.put("titleResolver", titleResolver);
            parameters.put("detailResolver", detailResolver);
        }
        return this.toProblem(throwable, code, ProblemMessageProvider.getMessage(titleResolver), ProblemMessageProvider.getMessage(detailResolver), parameters);
    }

    default public ThrowableProblem toProblem(Throwable throwable, MessageSourceResolvable codeResolver, MessageSourceResolvable titleResolver, MessageSourceResolvable detailResolver) {
        return this.toProblem(throwable, codeResolver, titleResolver, detailResolver, new LinkedHashMap<String, Object>());
    }

    default public ThrowableProblem toProblem(Throwable throwable, MessageSourceResolvable codeResolver, MessageSourceResolvable titleResolver, MessageSourceResolvable detailResolver, Map<String, Object> parameters) {
        if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
            parameters.put("codeResolver", codeResolver);
            parameters.put("titleResolver", titleResolver);
            parameters.put("detailResolver", detailResolver);
        }
        return this.toProblem(throwable, ProblemMessageProvider.getMessage(codeResolver), ProblemMessageProvider.getMessage(titleResolver), ProblemMessageProvider.getMessage(detailResolver), parameters);
    }

    default public ThrowableProblem toProblem(Throwable throwable, MessageSourceResolvable codeResolver, MessageSourceResolvable titleResolver, MessageSourceResolvable detailResolver, ProblemMessageSourceResolver statusResolver) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
            parameters.put("codeResolver", codeResolver);
            parameters.put("titleResolver", titleResolver);
            parameters.put("detailResolver", detailResolver);
            parameters.put("statusResolver", statusResolver);
        }
        return this.toProblem(throwable, ProblemMessageProvider.getMessage(codeResolver), ProblemMessageProvider.getMessage(titleResolver), ProblemMessageProvider.getMessage(detailResolver), parameters);
    }

    default public ThrowableProblem prepare(Throwable throwable, String code, String title, String detail, Map<String, Object> parameters) {
        if (ProblemBeanRegistry.problemProperties().isStacktraceEnabled()) {
            StackTraceElement[] stackTrace = ProblemUtils.createStackTrace(throwable);
            parameters.put("statcktrace", stackTrace);
        }
        return (ThrowableProblem)Problem.code(code).title(title).detail(detail).cause(Optional.ofNullable(throwable.getCause()).filter(cause -> ProblemBeanRegistry.problemProperties().isCauseChainsEnabled()).map(this::toProblem).orElse(null)).parameters(Collections.unmodifiableMap(parameters)).build();
    }
}

