/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.application;

import com.ksoot.problem.core.MultiProblem;
import com.ksoot.problem.core.Problem;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface ApplicationMultiProblemAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleApplicationProblem(MultiProblem exception, T request) {
        List<Problem> problems = exception.getProblems();
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(4);
        parameters.put("errors", problems);
        HttpStatus status = HttpStatus.MULTI_STATUS;
        ProblemMessageSourceResolver codeResolver = ProblemMessageSourceResolver.of("code.multiple.errors", status.value());
        ProblemMessageSourceResolver titleResolver = ProblemMessageSourceResolver.of("title.multiple.errors", status.getReasonPhrase());
        ProblemMessageSourceResolver detailResolver = ProblemMessageSourceResolver.of("detail.multiple.errors", exception.getMessage());
        ThrowableProblem problem = this.toProblem((Throwable)exception, (MessageSourceResolvable)codeResolver, (MessageSourceResolvable)titleResolver, (MessageSourceResolvable)detailResolver, parameters);
        return this.create((Throwable)exception, request, exception.getStatus(), problem);
    }
}

