/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.http;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.MimeTypeUtils;

public interface BaseNotAcceptableAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    default public R processMediaTypeNotSupportedException(List<MediaType> supportedMediaTypes, MediaType causeMediaType, Exception exception, T request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(supportedMediaTypes);
        ThrowableProblem problem = this.toProblem((Throwable)exception, HttpStatus.UNSUPPORTED_MEDIA_TYPE, ProblemMessageSourceResolver.of("detail.media.type.not.supported", "Media Type: {0} Not Acceptable, Supported Media Types are: {1}", new Object[]{causeMediaType, MimeTypeUtils.toString(supportedMediaTypes)}));
        return this.create(exception, request, HttpStatus.UNSUPPORTED_MEDIA_TYPE, headers, problem);
    }
}

