/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.io;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface MessageNotReadableAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleMessageNotReadableException(HttpMessageNotReadableException exception, T request) {
        Throwable throwable = exception.getCause();
        if (throwable instanceof InvalidFormatException) {
            InvalidFormatException invalidFormatException = (InvalidFormatException)throwable;
            return this.handleInvalidFormatException(invalidFormatException, request);
        }
        return this.create((Throwable)exception, request, HttpStatus.BAD_REQUEST);
    }

    default public R handleInvalidFormatException(InvalidFormatException invalidFormatException, T request) {
        String[] errorPropertyKeys = this.deriveInvalidFormatExceptionErrorKeys(invalidFormatException);
        String[] codeCodes = (String[])Arrays.stream(errorPropertyKeys).map(errorKey -> "code." + errorKey).toArray(String[]::new);
        String[] titleCodes = (String[])Arrays.stream(errorPropertyKeys).map(errorKey -> "title." + errorKey).toArray(String[]::new);
        String[] detailCodes = (String[])Arrays.stream(errorPropertyKeys).map(errorKey -> "detail." + errorKey).toArray(String[]::new);
        ThrowableProblem problem = this.toProblem((Throwable)invalidFormatException, ProblemMessageSourceResolver.of(codeCodes, "" + HttpStatus.BAD_REQUEST.value()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(titleCodes, HttpStatus.BAD_REQUEST.getReasonPhrase()), (MessageSourceResolvable)ProblemMessageSourceResolver.of(detailCodes, invalidFormatException.getMessage()));
        return this.create((Throwable)invalidFormatException, request, HttpStatus.BAD_REQUEST, problem);
    }

    default public String[] deriveInvalidFormatExceptionErrorKeys(InvalidFormatException invalidFormatException) {
        List pathRef = invalidFormatException.getPath();
        if (CollectionUtils.isNotEmpty((Collection)pathRef)) {
            String desc = ((JsonMappingException.Reference)pathRef.get(0)).getDescription();
            String packageName = desc.contains("[") ? desc.substring(0, desc.lastIndexOf(".")) : desc;
            List<String> classes = pathRef.stream().map(JsonMappingException.Reference::getDescription).filter(description -> description.contains("[\"")).map(description -> description.substring(description.lastIndexOf(".") + 1, description.lastIndexOf("["))).toList();
            String classNames = String.join((CharSequence)".", classes);
            JsonMappingException.Reference ref = (JsonMappingException.Reference)pathRef.get(pathRef.size() - 1);
            String fieldName = ref.getFieldName();
            String targetType = ClassUtils.getName((Class)invalidFormatException.getTargetType());
            return new String[]{"invalid.format." + packageName + "." + classNames + "." + fieldName, "invalid.format." + classNames + "." + fieldName, "invalid.format." + targetType + "." + fieldName, "invalid.format." + fieldName};
        }
        return new String[]{"invalid.format"};
    }
}

