/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.routing;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.NoHandlerFoundException;

public interface NoHandlerFoundAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleNoHandlerFound(NoHandlerFoundException exception, T request) {
        ThrowableProblem problem = this.toProblem((Throwable)exception, ProblemMessageSourceResolver.of("code.no.handler.found", HttpStatus.NOT_FOUND.value()), (MessageSourceResolvable)ProblemMessageSourceResolver.of("title.no.handler.found", HttpStatus.NOT_FOUND.getReasonPhrase()), (MessageSourceResolvable)ProblemMessageSourceResolver.of("detail.no.handler.found", exception.getMessage()));
        return this.create((Throwable)exception, request, HttpStatus.NOT_FOUND, problem);
    }
}

