/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.boot.autoconfigure;

import com.ksoot.problem.spring.advice.dao.ConstraintNameResolver;
import com.ksoot.problem.spring.advice.dao.MongoConstraintNameResolver;
import com.ksoot.problem.spring.advice.dao.PostgresConstraintNameResolver;
import com.ksoot.problem.spring.advice.dao.SQLServerConstraintNameResolver;
import com.ksoot.problem.spring.boot.autoconfigure.DaoAdviceEnabled;
import com.ksoot.problem.spring.boot.autoconfigure.ORMAdviceEnabled;
import com.ksoot.problem.spring.boot.autoconfigure.ORMUrlAvailable;
import com.ksoot.problem.spring.config.ProblemProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.MongoDatabaseFactory;

@EnableConfigurationProperties(value={ProblemProperties.class})
@Conditional(value={DaoAdviceEnabled.class, ORMAdviceEnabled.class})
@ConditionalOnWebApplication
@AutoConfiguration
@AutoConfigureOrder(value=-2147483648)
@Order(value=-2147483648)
class ProblemDaoConfiguration {
    ProblemDaoConfiguration() {
    }

    @ConditionalOnClass(value={MongoDatabaseFactory.class})
    @ConditionalOnProperty(prefix="spring.data.mongodb", name={"uri"})
    @ConditionalOnMissingBean(name={"mongoConstraintNameResolver"})
    public static class MongoConstraintNameResolverConfiguration {
        @Bean
        public ConstraintNameResolver mongoConstraintNameResolver(Environment env) {
            return new MongoConstraintNameResolver();
        }
    }

    @ConditionalOnMissingBean(name={"sqlServerConstraintNameResolver"})
    @Conditional(value={ORMUrlAvailable.class})
    @ConditionalOnProperty(prefix="spring.jpa", name={"database"}, havingValue="SQL_SERVER")
    public static class SQLServerConstraintNameResolverConfiguration {
        @Bean
        public ConstraintNameResolver sqlServerConstraintNameResolver(Environment env) {
            return new SQLServerConstraintNameResolver();
        }
    }

    @ConditionalOnMissingBean(name={"postgresqlConstraintNameResolver"})
    @Conditional(value={ORMUrlAvailable.class})
    @ConditionalOnProperty(prefix="spring.jpa", name={"database"}, havingValue="POSTGRESQL")
    public static class PostgresqlConstraintNameResolverConfiguration {
        @Bean
        public ConstraintNameResolver postgresqlConstraintNameResolver(Environment env) {
            return new PostgresConstraintNameResolver();
        }
    }
}

