/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.boot.autoconfigure.web;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.springmvc.OpenApiValidationInterceptor;
import com.atlassian.oai.validator.springmvc.ValidationReportHandler;
import com.ksoot.problem.spring.advice.validation.OpenApiValidationAdviceTrait;
import com.ksoot.problem.spring.boot.autoconfigure.OpenAPIValidationAdviceEnabled;
import com.ksoot.problem.spring.boot.autoconfigure.web.PathConfigurableOpenApiValidationFilter;
import com.ksoot.problem.spring.config.ProblemConfigException;
import com.ksoot.problem.spring.config.ProblemProperties;
import jakarta.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.NativeWebRequest;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ProblemProperties.class})
@ConditionalOnClass(value={ValidationReportHandler.class})
@Conditional(value={OpenAPIValidationAdviceEnabled.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Order(value=-2147483648)
@ControllerAdvice
class OpenApiValidationExceptionHandler
implements OpenApiValidationAdviceTrait<NativeWebRequest, ResponseEntity<ProblemDetail>> {
    private final ProblemProperties problemProperties;

    @Bean
    public OpenApiValidationInterceptor validationInterceptor() {
        if (StringUtils.isBlank((CharSequence)this.problemProperties.getOpenApi().getPath())) {
            throw new ProblemConfigException("Invalid OpenAPI Spec file: " + this.problemProperties.getOpenApi().getPath());
        }
        OpenApiInteractionValidator validator = OpenApiInteractionValidator.createFor((String)this.problemProperties.getOpenApi().getPath()).build();
        return new OpenApiValidationInterceptor(validator);
    }

    @Bean
    public Filter validationFilter() {
        return new PathConfigurableOpenApiValidationFilter(this.problemProperties.getOpenApi());
    }

    public OpenApiValidationExceptionHandler(ProblemProperties problemProperties) {
        this.problemProperties = problemProperties;
    }
}

