/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.boot.autoconfigure.web;

import com.ksoot.problem.core.ErrorResponseBuilder;
import com.ksoot.problem.core.MediaTypes;
import com.ksoot.problem.core.Problem;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

class SpringWebErrorResponseBuilder
implements ErrorResponseBuilder<NativeWebRequest, ResponseEntity<ProblemDetail>> {
    SpringWebErrorResponseBuilder() {
    }

    public static Optional<MediaType> negotiate(NativeWebRequest request) {
        ContentNegotiationStrategy negotiator = DEFAULT_CONTENT_NEGOTIATION_STRATEGY;
        List mediaTypes = negotiator.resolveMediaTypes(request);
        return ErrorResponseBuilder.getProblemMediaType(mediaTypes);
    }

    @Override
    public ResponseEntity<ProblemDetail> buildResponse(Throwable throwable, NativeWebRequest request, HttpStatus status, HttpHeaders headers, Problem problem) {
        if (status == HttpStatus.INTERNAL_SERVER_ERROR) {
            request.setAttribute("jakarta.servlet.error.exception", (Object)throwable, 0);
        }
        ProblemDetail problemDetail = this.createProblemDetail(request, status, problem);
        Optional<ResponseEntity> responseEntity = SpringWebErrorResponseBuilder.negotiate(request).map(contentType -> ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).headers(headers)).contentType(contentType).body((Object)problemDetail));
        if (responseEntity.isPresent()) {
            return this.postProcess((ResponseEntity<ProblemDetail>)responseEntity.get(), request);
        }
        return this.fallback(request, status, headers, problem);
    }

    private ResponseEntity<ProblemDetail> postProcess(ResponseEntity<ProblemDetail> errorResponse, NativeWebRequest request) {
        return errorResponse;
    }

    private ResponseEntity<ProblemDetail> fallback(NativeWebRequest request, HttpStatus status, HttpHeaders headers, Problem problem) {
        ProblemDetail problemDetail = this.createProblemDetail(request, status, problem);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).headers(headers)).contentType(MediaTypes.PROBLEM).body((Object)problemDetail);
    }

    @Override
    public URI requestUri(NativeWebRequest request) {
        return URI.create(((HttpServletRequest)request.getNativeRequest(HttpServletRequest.class)).getRequestURI());
    }

    @Override
    public HttpMethod requestMethod(NativeWebRequest request) {
        return HttpMethod.valueOf((String)((HttpServletRequest)request.getNativeRequest(HttpServletRequest.class)).getMethod());
    }
}

