/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.core;

import com.ksoot.problem.core.DefaultProblem;
import com.ksoot.problem.core.ThrowableProblem;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public interface Problem {
    public String getCode();

    public String getTitle();

    public String getDetail();

    public ThrowableProblem getCause();

    default public Map<String, Object> getParameters() {
        return Collections.emptyMap();
    }

    public static String toString(Problem problem) {
        Stream<String> parts = Stream.concat(Stream.of(problem.getCode(), problem.getTitle(), problem.getDetail()), problem.getParameters().entrySet().stream().map(Object::toString)).filter(Objects::nonNull);
        return problem.getCode() + "{" + parts.collect(Collectors.joining(", ")) + "}";
    }

    public static TitleBuilder code(String code) {
        return new Builder(code);
    }

    public static DetailBuilder of(HttpStatus status) {
        return new Builder("" + status.value(), status.getReasonPhrase());
    }

    public static CauseBuilder of(String code, String title, String detail) {
        return new Builder(code, title, detail);
    }

    public static class Builder
    implements TitleBuilder,
    DetailBuilder,
    CauseBuilder {
        private static final Set<String> RESERVED_PROPERTIES = new HashSet<String>(Arrays.asList("code", "title", "detail", "cause"));
        private String code;
        private String title;
        private String detail;
        private ThrowableProblem cause;
        private final Map<String, Object> parameters = new LinkedHashMap<String, Object>();

        Builder(String code) {
            Assert.hasText((String)code, (String)"'code' must not be null or empty");
            this.code = code;
        }

        Builder(String code, String title) {
            this(code);
            Assert.hasText((String)title, (String)"'title' must not be null or empty");
            this.title = title;
        }

        Builder(String code, String title, String detail) {
            this(code, title);
            this.detail = detail;
        }

        Builder(String code, String title, String detail, ThrowableProblem cause) {
            this(code, title, detail);
            this.cause = cause;
        }

        Builder(String code, String title, String detail, ThrowableProblem cause, Map<String, Object> parameters) {
            this(code, title, detail, cause);
            if (MapUtils.isNotEmpty(parameters)) {
                this.parameters.putAll(parameters);
            }
        }

        @Override
        public DetailBuilder title(String title) {
            Assert.hasText((String)title, (String)"'title' must not be null or empty");
            this.title = title;
            return this;
        }

        @Override
        public CauseBuilder detail(String detail) {
            this.detail = detail;
            return this;
        }

        @Override
        public ParameterBuilder cause(@Nullable ThrowableProblem cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ParameterBuilder parameter(String key, Object value) {
            Assert.hasText((String)key, (String)"'key' must not be null or empty");
            Assert.isTrue((!RESERVED_PROPERTIES.contains(key) ? 1 : 0) != 0, (String)("Property " + key + " is reserved"));
            this.parameters.put(key, value);
            return this;
        }

        @Override
        public org.apache.commons.lang3.builder.Builder<ThrowableProblem> parameters(@Nullable Map<String, Object> parameters) {
            if (MapUtils.isNotEmpty(parameters)) {
                parameters.entrySet().stream().forEach(entry -> this.parameter((String)entry.getKey(), entry.getValue()));
            }
            return this;
        }

        public ThrowableProblem build() {
            return new DefaultProblem(this.code, this.title, this.detail, this.cause, this.parameters);
        }
    }

    public static interface ParametersBuilder
    extends org.apache.commons.lang3.builder.Builder<ThrowableProblem> {
        public org.apache.commons.lang3.builder.Builder<ThrowableProblem> parameters(@Nullable Map<String, Object> var1);
    }

    public static interface ParameterBuilder
    extends ParametersBuilder {
        public ParameterBuilder parameter(String var1, Object var2);
    }

    public static interface CauseBuilder
    extends ParameterBuilder {
        public ParameterBuilder cause(@Nullable ThrowableProblem var1);
    }

    public static interface DetailBuilder {
        public CauseBuilder detail(String var1);
    }

    public static interface TitleBuilder {
        public DetailBuilder title(String var1);
    }
}

