/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.io;

import com.google.common.base.CharMatcher;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.AdviceTrait;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.impl.FileSizeLimitExceededException;
import org.springframework.http.HttpStatus;
import org.springframework.util.unit.DataSize;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

public interface MaxUploadSizeExceededExceptionAdviceTrait<T, R>
extends AdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleMaxUploadSizeExceededException(MaxUploadSizeExceededException exception, T request) {
        Throwable throwable;
        String errorKey = ClassUtils.getName((Object)exception);
        String defultMessage = exception.getMessage();
        long bytes = exception.getMaxUploadSize();
        if (bytes == -1L && (throwable = exception.getMostSpecificCause()) instanceof FileSizeLimitExceededException) {
            FileSizeLimitExceededException e = (FileSizeLimitExceededException)throwable;
            defultMessage = e.getMessage();
            String byteSizeString = CharMatcher.inRange((char)'0', (char)'9').retainFrom((CharSequence)defultMessage);
            bytes = StringUtils.isNotBlank((CharSequence)byteSizeString) ? Long.parseLong(byteSizeString) : bytes;
        }
        String maxFileSizeAllowed = bytes != -1L ? DataSize.ofBytes((long)bytes).toString() : "UNKNOWN";
        String detailCode = "detail." + errorKey;
        ThrowableProblem problem = this.toProblem((Throwable)exception, HttpStatus.BAD_REQUEST, ProblemMessageSourceResolver.of(detailCode, defultMessage, new Object[]{maxFileSizeAllowed}));
        return this.create((Throwable)exception, request, HttpStatus.BAD_REQUEST, problem);
    }
}

