/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem.spring.advice.validation;

import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.advice.validation.BaseValidationAdviceTrait;
import com.ksoot.problem.spring.advice.validation.ViolationVM;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface ConstraintViolationAdviceTrait<T, R>
extends BaseValidationAdviceTrait<T, R> {
    @ExceptionHandler
    default public R handleConstraintViolationException(ConstraintViolationException exception, T request) {
        List<ViolationVM> violations = exception.getConstraintViolations().stream().map(violation -> this.handleConstraintViolation((ConstraintViolation)violation, exception)).toList();
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(4);
        parameters.put("violations", violations);
        ThrowableProblem problem = this.toProblem((Throwable)exception, (MessageSourceResolvable)ProblemMessageSourceResolver.of("code.constraint.violation"), (MessageSourceResolvable)ProblemMessageSourceResolver.of("title.constraint.violation"), (MessageSourceResolvable)ProblemMessageSourceResolver.of("detail.constraint.violation", exception.getMessage()), parameters);
        return this.create((Throwable)exception, request, this.defaultConstraintViolationStatus(), problem);
    }

    default public ViolationVM handleConstraintViolation(ConstraintViolation violation, ConstraintViolationException exception) {
        HttpStatus status = this.defaultConstraintViolationStatus();
        ProblemMessageSourceResolver codeResolver = ProblemMessageSourceResolver.of("code.constraint.violation", violation, status.name());
        ProblemMessageSourceResolver messageResolver = ProblemMessageSourceResolver.of("detail.constraint.violation", violation);
        return this.createViolation(codeResolver, messageResolver, violation.getPropertyPath().toString());
    }
}

