/*
 * Decompiled with CFR 0.152.
 */
package com.ksoot.problem;

import com.ksoot.problem.core.ApplicationException;
import com.ksoot.problem.core.ApplicationProblem;
import com.ksoot.problem.core.MultiProblem;
import com.ksoot.problem.core.Problem;
import com.ksoot.problem.core.ProblemUtils;
import com.ksoot.problem.core.ThrowableProblem;
import com.ksoot.problem.spring.config.ProblemBeanRegistry;
import com.ksoot.problem.spring.config.ProblemMessageProvider;
import com.ksoot.problem.spring.config.ProblemMessageSourceResolver;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public final class Problems {
    public static CauseBuilder newInstance(String code, String title, String detail) {
        return new Builder(code, title, detail);
    }

    public static CauseBuilder newInstance(MessageSourceResolvable codeResolver, MessageSourceResolvable titleResolver, MessageSourceResolvable detailResolver) {
        return new Builder(codeResolver, titleResolver, detailResolver);
    }

    public static DefaultDetailBuilder newInstance(String errorKey) {
        return new Builder(errorKey);
    }

    public static TitleBuilder newInstance(MessageSourceResolvable codeResolver) {
        return new Builder(codeResolver);
    }

    public static ApplicationProblem throwAble(HttpStatus status, Problem problem) {
        Assert.notNull((Object)problem, (String)"'problem' must not be null");
        return new ApplicationProblem(status, problem.getCode(), problem.getTitle(), problem.getDetail(), problem.getCause(), problem.getParameters());
    }

    public static MultiProblem throwAble(HttpStatus status, List<Problem> problems) {
        return MultiProblem.of(status, problems);
    }

    public static MultiProblem throwAble(HttpStatus status, Problem ... problems) {
        Assert.notNull((Object)problems, (String)"'problems' must not be null");
        return MultiProblem.of(status, Arrays.asList(problems));
    }

    public static ApplicationException throwAbleChecked(HttpStatus status, Problem problem) {
        Assert.notNull((Object)problem, (String)"'problem' must not be null");
        return new ApplicationException(status, problem.getCode(), problem.getTitle(), problem.getDetail(), problem.getCause(), problem.getParameters());
    }

    public static ApplicationProblem notFound() {
        return Problems.newInstance("not.found").throwAble(HttpStatus.NOT_FOUND);
    }

    public static ApplicationProblem internalServerError() {
        return Problems.newInstance("internal.server.error").throwAble(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private Problems() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Builder
    implements TitleBuilder,
    DetailBuilder,
    DefaultDetailBuilder {
        private static final Set<String> RESERVED_PROPERTIES = new HashSet<String>(Arrays.asList("code", "title", "detail", "cause", "codeResolver", "titleResolver", "detailResolver"));
        private String code;
        private String title;
        private String detail;
        private String errorKey;
        private String defaultDetail;
        private Object[] detailArgs;
        private ThrowableProblem cause;
        private Map<String, Object> parameters = new LinkedHashMap<String, Object>(4);

        Builder(String code, String title, String detail) {
            this.code = code;
            this.title = title;
            this.detail = detail;
        }

        Builder(String errorKey) {
            this.errorKey = errorKey;
        }

        Builder(MessageSourceResolvable codeResolver) {
            this.code = ProblemMessageProvider.getMessage(codeResolver);
            this.parameters.put("codeResolver", codeResolver);
        }

        Builder(MessageSourceResolvable codeResolver, MessageSourceResolvable titleResolver, MessageSourceResolvable detailResolver) {
            this(ProblemMessageProvider.getMessage(codeResolver), ProblemMessageProvider.getMessage(titleResolver), ProblemMessageProvider.getMessage(detailResolver));
            if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
                this.parameters.put("codeResolver", codeResolver);
                this.parameters.put("titleResolver", titleResolver);
                this.parameters.put("detailResolver", detailResolver);
            }
        }

        @Override
        public DetailBuilder title(MessageSourceResolvable titleResolver) {
            Assert.notNull((Object)titleResolver, (String)"'titleResolver' must not be null");
            this.title = ProblemMessageProvider.getMessage(titleResolver);
            if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
                this.parameters.put("titleResolver", titleResolver);
            }
            return this;
        }

        @Override
        public DefaultDetailBuilder detail(MessageSourceResolvable detailResolver) {
            Assert.notNull((Object)detailResolver, (String)"'detailResolver' must not be null");
            this.detail = ProblemMessageProvider.getMessage(detailResolver);
            if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
                this.parameters.put("messageResolver", detailResolver);
            }
            return this;
        }

        @Override
        public DetailArgsBuilder defaultDetail(@Nullable String detail) {
            this.defaultDetail = detail;
            return this;
        }

        @Override
        public CauseBuilder detailArgs(Object ... detailArgs) {
            this.detailArgs = detailArgs;
            return this;
        }

        @Override
        public ParameterBuilder cause(@Nullable Throwable cause) {
            this.cause = cause != null ? ProblemUtils.toProblem(cause) : null;
            return this;
        }

        @Override
        public ParameterBuilder parameter(String key, Object value) {
            Assert.hasLength((String)key, (String)"'key' must not be null or empty");
            Assert.isTrue((!RESERVED_PROPERTIES.contains(key) ? 1 : 0) != 0, (String)("Property " + key + " is reserved"));
            this.parameters.put(key, value);
            return this;
        }

        @Override
        public ProblemBuildable parameters(@Nullable Map<String, Object> parameters) {
            if (MapUtils.isNotEmpty(parameters)) {
                parameters.entrySet().stream().forEach(entry -> this.parameter((String)entry.getKey(), entry.getValue()));
            }
            return this;
        }

        private void setParamsByErrorKey() {
            if (StringUtils.isNotEmpty((CharSequence)this.errorKey)) {
                ProblemMessageSourceResolver codeResolver = ProblemMessageSourceResolver.of("code." + this.errorKey);
                ProblemMessageSourceResolver titleResolver = ProblemMessageSourceResolver.of("title." + this.errorKey);
                ProblemMessageSourceResolver detailResolver = ProblemMessageSourceResolver.of("detail." + this.errorKey, this.defaultDetail, this.detailArgs);
                this.code = ProblemMessageProvider.getMessage(codeResolver);
                this.title = ProblemMessageProvider.getMessage(titleResolver);
                this.detail = ProblemMessageProvider.getMessage(detailResolver);
                if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
                    this.parameters.put("codeResolver", codeResolver);
                    this.parameters.put("titleResolver", titleResolver);
                    this.parameters.put("detail.", detailResolver);
                }
            }
        }

        private void setParamsByErrorKey(HttpStatus status) {
            if (StringUtils.isNotEmpty((CharSequence)this.errorKey)) {
                ProblemMessageSourceResolver codeResolver = ProblemMessageSourceResolver.of("code." + this.errorKey, status.value());
                ProblemMessageSourceResolver titleResolver = ProblemMessageSourceResolver.of("title." + this.errorKey, status.getReasonPhrase());
                ProblemMessageSourceResolver detailResolver = ProblemMessageSourceResolver.of("detail." + this.errorKey, this.defaultDetail, this.detailArgs);
                this.code = ProblemMessageProvider.getMessage(codeResolver);
                this.title = ProblemMessageProvider.getMessage(titleResolver);
                this.detail = ProblemMessageProvider.getMessage(detailResolver);
                if (ProblemBeanRegistry.problemProperties().isDebugEnabled()) {
                    this.parameters.put("codeResolver", codeResolver);
                    this.parameters.put("titleResolver", titleResolver);
                    this.parameters.put("detail.", detailResolver);
                }
            }
        }

        @Override
        public Problem get() {
            this.setParamsByErrorKey();
            return (Problem)Problem.of(this.code, this.title, this.detail).cause(this.cause).parameters(this.parameters).build();
        }

        @Override
        public ApplicationProblem throwAble(HttpStatus status) {
            this.setParamsByErrorKey(status);
            return ApplicationProblem.of(status, this.code, this.title, this.detail, this.cause, this.parameters);
        }

        @Override
        public ApplicationException throwAbleChecked(HttpStatus status) {
            this.setParamsByErrorKey(status);
            return ApplicationException.of(status, this.code, this.title, this.detail, this.cause, this.parameters);
        }
    }

    public static interface DefaultDetailBuilder
    extends DetailArgsBuilder {
        public DetailArgsBuilder defaultDetail(@Nullable String var1);
    }

    public static interface ProblemBuildable {
        public Problem get();

        public ApplicationProblem throwAble(HttpStatus var1);

        public ApplicationException throwAbleChecked(HttpStatus var1);
    }

    public static interface ParametersBuilder
    extends ProblemBuildable {
        public ProblemBuildable parameters(@Nullable Map<String, Object> var1);
    }

    public static interface ParameterBuilder
    extends ParametersBuilder {
        public ParameterBuilder parameter(String var1, Object var2);
    }

    public static interface CauseBuilder
    extends ParameterBuilder {
        public ParameterBuilder cause(@Nullable Throwable var1);
    }

    public static interface DetailArgsBuilder
    extends CauseBuilder {
        public CauseBuilder detailArgs(Object ... var1);
    }

    public static interface DetailBuilder {
        public DefaultDetailBuilder detail(MessageSourceResolvable var1);
    }

    public static interface TitleBuilder {
        public DetailBuilder title(MessageSourceResolvable var1);
    }
}

